/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.backbags.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.backbags.BackBagInventory;
import com.gmail.berndivader.mythicmobsext.compatibilitylib.NMSUtils;
import com.gmail.berndivader.mythicmobsext.items.HoldingItem;
import com.gmail.berndivader.mythicmobsext.items.WhereEnum;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RestoreFromBackBag
extends SkillMechanic
implements INoTargetSkill,
ITargetedEntitySkill {
    int to_slot;
    WhereEnum what;
    boolean override;
    PlaceholderString meta_name;
    PlaceholderString from_slot;
    PlaceholderString bag_name;
    HoldingItem holding;

    public RestoreFromBackBag(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.from_slot = mlc.getPlaceholderString("fromslot", "-1");
        this.to_slot = mlc.getInteger("toslot", -1);
        this.override = mlc.getBoolean("override", true);
        this.what = WhereEnum.getWhere(mlc.getString("to"));
        this.bag_name = mlc.getPlaceholderString(new String[]{"title", "name"}, BackBagHelper.str_name, new String[0]);
    }

    public boolean cast(SkillMetadata data) {
        return this.castAtEntity(data, data.getCaster().getEntity());
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity abstract_entity) {
        int inventory_slot = -1;
        try {
            inventory_slot = Integer.parseInt(this.from_slot.get((PlaceholderMeta)data, abstract_entity));
        }
        catch (Exception ex) {
            Main.logger.warning("Invalid Integer for slot (reset to default -1) in skillline: " + this.line);
        }
        if (abstract_entity.isLiving() && BackBagHelper.hasBackBag(abstract_entity.getUniqueId())) {
            ItemStack old_item;
            LivingEntity holder = (LivingEntity)abstract_entity.getBukkitEntity();
            BackBagInventory bag = BackBagHelper.getBagInventory(holder.getUniqueId(), this.bag_name.get((PlaceholderMeta)data, abstract_entity));
            this.holding.parseSlot(data, abstract_entity);
            Inventory inventory = bag.getInventory();
            if (inventory.getSize() >= inventory_slot && inventory_slot > -1 && (old_item = inventory.getItem(inventory_slot)) != null) {
                if (this.what == WhereEnum.TAG) {
                    this.what = WhereEnum.getWhere(NMSUtils.getMetaString(old_item, "BAG_POS_TAG"));
                }
                switch (this.what) {
                    case SLOT: 
                    case INVENTORY: {
                        if (!abstract_entity.isPlayer()) break;
                        Player player = (Player)holder;
                        int tmp_slot = this.to_slot;
                        if (this.to_slot > -1 && player.getInventory().getMaxStackSize() >= this.to_slot) {
                            if (this.override) {
                                player.getInventory().setItem(this.to_slot, old_item.clone());
                                RestoreFromBackBag.clearItem(old_item);
                                break;
                            }
                            if (player.getInventory().getItem(this.to_slot) != null && player.getInventory().getItem(inventory_slot).getType() != Material.AIR) break;
                            player.getInventory().setItem(this.to_slot, old_item.clone());
                            RestoreFromBackBag.clearItem(old_item);
                            break;
                        }
                        tmp_slot = player.getInventory().firstEmpty();
                        if (tmp_slot <= -1) break;
                        player.getInventory().setItem(tmp_slot, old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                    case HELMET: {
                        holder.getEquipment().setHelmet(old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                    case CHESTPLATE: {
                        holder.getEquipment().setChestplate(old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                    case LEGGINGS: {
                        holder.getEquipment().setLeggings(old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                    case OFFHAND: {
                        holder.getEquipment().setItemInOffHand(old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                    case HAND: {
                        holder.getEquipment().setItemInMainHand(old_item.clone());
                        RestoreFromBackBag.clearItem(old_item);
                        break;
                    }
                }
            }
        }
        return true;
    }

    static void clearItem(ItemStack item) {
        item.setAmount(0);
        item.setType(Material.AIR);
    }
}

