/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.targeters.CustomTargeters;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitPlayer;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.targeters.ConsoleTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.CustomTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.skills.targeters.OriginTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TargetLocationTargeter;
import io.lumine.xikage.mythicmobs.skills.targeters.TriggerTargeter;
import java.util.HashSet;
import java.util.Optional;

@ExternalAnnotation(name="checktargeter,targetcondition", author="Seyarada")
public class CheckTargeter
extends AbstractCustomCondition
implements IEntityCondition {
    private PlaceholderString stargeter;
    private SkillCondition condition;
    private Boolean forFalse;

    public CheckTargeter(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String s = mlc.getString(new String[]{"targeter", "t"}, "@self", new String[0]);
        this.forFalse = mlc.getBoolean(new String[]{"false", "f"}, false);
        this.stargeter = new PlaceholderString(s);
        String conditionString = mlc.getString(new String[]{"condition", "cond", "c"});
        this.condition = SkillCondition.getCondition((String)conditionString);
    }

    public boolean check(AbstractEntity caster) {
        HashSet<?> entries;
        SkillMetadata data = new SkillMetadata(SkillTrigger.API, (SkillCaster)new GenericCaster(caster), caster);
        String targeter = this.stargeter.get((PlaceholderMeta)data);
        if (caster.getClass().equals(BukkitEntity.class) || caster.getClass().equals(BukkitPlayer.class)) {
            targeter = this.stargeter.get((PlaceholderMeta)data, caster);
        }
        if ((entries = this.getDestination(targeter, data)).size() == 0) {
            return false;
        }
        for (Object i : this.getDestination(targeter, data)) {
            if (i instanceof BukkitEntity) {
                data.setEntityTarget((AbstractEntity)i);
            } else if (i instanceof AbstractLocation) {
                data.setLocationTarget((AbstractLocation)i);
            }
            boolean a2 = this.condition.evaluateTargets(data);
            if (this.forFalse.booleanValue()) {
                boolean bl = a2 = !a2;
            }
            if (a2) continue;
            return a2;
        }
        return true;
    }

    protected HashSet<?> getDestination(String target, SkillMetadata skilldata) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.API, skilldata.getCaster(), skilldata.getTrigger(), skilldata.getOrigin(), null, null, 1.0f);
        Optional<SkillTargeter> maybeTargeter = Optional.of(Utils.parseSkillTargeter(target));
        if (maybeTargeter.isPresent()) {
            SkillTargeter targeter = maybeTargeter.get();
            if (targeter instanceof CustomTargeter) {
                String s1 = target.substring(1);
                MythicLineConfig mlc = new MythicLineConfig(s1);
                String s2 = s1.contains("{") ? s1.substring(0, s1.indexOf("{")) : s1;
                targeter = CustomTargeters.getCustomTargeter(s2, mlc);
                if (targeter == null) {
                    targeter = new TriggerTargeter(mlc);
                }
            }
            if (targeter instanceof IEntitySelector) {
                data.setEntityTargets(((IEntitySelector)targeter).getEntities(data));
                ((IEntitySelector)targeter).filter(data, false);
                return data.getEntityTargets();
            }
            if (targeter instanceof ILocationSelector) {
                data.setLocationTargets(((ILocationSelector)targeter).getLocations(data));
                ((ILocationSelector)targeter).filter(data);
            } else if (targeter instanceof OriginTargeter) {
                data.setLocationTargets(((OriginTargeter)targeter).getLocation(data.getOrigin()));
            } else if (targeter instanceof TargetLocationTargeter) {
                HashSet<AbstractLocation> lTargets = new HashSet<AbstractLocation>();
                lTargets.add(data.getTrigger().getLocation());
                data.setLocationTargets(lTargets);
            }
            if (targeter instanceof ConsoleTargeter) {
                data.setEntityTargets(null);
                data.setLocationTargets(null);
            }
            return data.getLocationTargets();
        }
        return null;
    }
}

