/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.GenericCaster;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ExternalAnnotation(name="comparevariable,cmpvar", author="BerndiVader")
public class CompareVariables
extends AbstractCustomCondition
implements IEntityComparisonCondition {
    PlaceholderString compare;
    Pattern pattern;

    public CompareVariables(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.compare = mlc.getPlaceholderString(new String[]{"c", "cmp", "compare"}, "", new String[0]);
        this.pattern = Pattern.compile("[=<>]+");
    }

    public boolean check(AbstractEntity caster, AbstractEntity target) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.API, (SkillCaster)new GenericCaster(caster), target);
        String outcome = this.compare.get((PlaceholderMeta)data, target);
        Matcher matcher = this.pattern.matcher(outcome);
        if (matcher.find()) {
            String equal = matcher.group();
            String[] parsed = outcome.split("[=<>]+");
            if (parsed.length == 2) {
                RangedDouble ranged = new RangedDouble(equal + parsed[1]);
                return ranged.equals(Double.parseDouble(parsed[0]));
            }
        }
        return false;
    }
}

