/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.backbags.BackBagHelper;
import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;

@ExternalAnnotation(name="openinventory", author="nicochulo2001")
public class OpenInventoryCondition
extends AbstractCustomCondition
implements IEntityCondition {
    private String type;
    private String name;

    public OpenInventoryCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.type = mlc.getString(new String[]{"type", "t"}, "CRAFTING", new String[0]);
        this.name = mlc.getString(new String[]{"name", "n"}, null, new String[0]);
    }

    public boolean check(AbstractEntity target) {
        if (target.getBukkitEntity() instanceof Player) {
            Player p = (Player)target.getBukkitEntity();
            InventoryView invView = p.getOpenInventory();
            InventoryType invType = invView.getType();
            String invName = invView.getTitle();
            if (invType.toString().equals(this.type)) {
                if (this.name != null) {
                    return invName.equals(this.name);
                }
                return true;
            }
            if (this.type.equals("BACKBAG")) {
                return invView.getTopInventory() == BackBagHelper.getInventory(target.getUniqueId(), this.name);
            }
            return false;
        }
        return false;
    }
}

