/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.conditions;

import com.gmail.berndivader.mythicmobsext.conditions.AbstractCustomCondition;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@ExternalAnnotation(name="ownsmythicitem", author="Seyarada")
public class OwnsMythicItem
extends AbstractCustomCondition
implements IEntityCondition {
    private ItemStack mythicItem;

    public OwnsMythicItem(String line, MythicLineConfig mlc) {
        super(line, mlc);
        String baseMLC = mlc.getString(new String[]{"item", "i"}, "STONE", new String[0]);
        try {
            Material baseMaterial = Material.valueOf((String)baseMLC);
            this.mythicItem = new ItemStack(baseMaterial);
        }
        catch (Exception e) {
            ItemStack item;
            Optional t = MythicMobs.inst().getItemManager().getItem(baseMLC);
            this.mythicItem = item = BukkitAdapter.adapt((AbstractItemStack)((MythicItem)t.get()).generateItemStack(1));
        }
    }

    public boolean check(AbstractEntity target) {
        Player p = (Player)target.getBukkitEntity();
        ArrayList<Boolean> b = new ArrayList<Boolean>();
        b.add(p.getInventory().containsAtLeast(this.mythicItem, 1));
        b.add(p.getEquipment().getItemInOffHand().isSimilar(this.mythicItem));
        for (Boolean i : b) {
            if (!i.booleanValue()) continue;
            return i;
        }
        return false;
    }
}

