/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.guardianbeam;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.guardianbeam.Beam;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="guardianbeam", author="BerndiVader")
public class GuardianBeamMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    int duration;
    double forwardOffset;
    double sideOffset;
    double yOffset;

    public GuardianBeamMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.duration = mlc.getInteger("duration", 1);
        this.forwardOffset = mlc.getDouble("forward", 1.0);
        this.sideOffset = mlc.getDouble("side", 0.0);
        this.yOffset = mlc.getDouble("yoffset", 1.0);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity e) {
        return this.cast(data, e.getLocation(), e.getBukkitEntity());
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation l) {
        return this.cast(data, l, null);
    }

    public boolean cast(SkillMetadata data, AbstractLocation l, Entity e) {
        final Entity caster = data.getCaster().getEntity().getBukkitEntity();
        Location end = BukkitAdapter.adapt((AbstractLocation)l);
        Vector foV = MathUtils.getFrontBackOffsetVector(caster.getLocation().getDirection(), this.forwardOffset);
        final Beam beam = new Beam(caster.getLocation().add(foV).add(0.0, this.yOffset, 0.0), end);
        beam.start();
        new BukkitRunnable(){
            int t = 0;
            Location ol;
            {
                this.ol = caster.getLocation().add(MathUtils.getFrontBackOffsetVector(caster.getLocation().getDirection(), GuardianBeamMechanic.this.forwardOffset)).add(0.0, GuardianBeamMechanic.this.yOffset, 0.0);
            }

            public void run() {
                if (this.t < GuardianBeamMechanic.this.duration) {
                    Location l1 = caster.getLocation().add(MathUtils.getFrontBackOffsetVector(caster.getLocation().getDirection(), GuardianBeamMechanic.this.forwardOffset)).add(0.0, GuardianBeamMechanic.this.yOffset, 0.0);
                    Location l = this.ol.subtract(l1);
                    l.setYaw(caster.getLocation().getYaw());
                    l.setPitch(caster.getLocation().getPitch());
                    beam.setStartingPosition(l);
                    this.ol = l1;
                } else {
                    if (beam.isActive()) {
                        beam.stop();
                    }
                    this.cancel();
                }
                ++this.t;
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, 0L);
        return false;
    }
}

