/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.jboolexpr;

import com.gmail.berndivader.mythicmobsext.jboolexpr.MalformedBooleanException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class BooleanUtil {
    private BooleanUtil() {
    }

    static String validAndformat(String booleanExpression) throws MalformedBooleanException {
        BooleanUtil.validNull(booleanExpression);
        BooleanUtil.validRegexp(booleanExpression);
        BooleanUtil.validParenthesis(booleanExpression);
        return BooleanUtil.format(booleanExpression);
    }

    private static void validNull(String booleanExpression) {
        if (booleanExpression == null || booleanExpression.equals("")) {
            throw new IllegalArgumentException("booleanExpression is null or void");
        }
    }

    private static void validRegexp(String booleanExpression) throws MalformedBooleanException {
        String regexp = "(\\(|\\)|\\|{2}|\\&{2}|!|(false)|(true)|\\s)+";
        if (!booleanExpression.matches("^" + regexp + "$")) {
            Matcher matcher = Pattern.compile(regexp).matcher(booleanExpression);
            ArrayList<Integer> errorIndexes = new ArrayList<Integer>();
            while (matcher.find()) {
                int end;
                int start = matcher.start();
                if (start != 0) {
                    errorIndexes.add(new Integer(start));
                }
                if ((end = matcher.end()) == booleanExpression.length()) continue;
                errorIndexes.add(new Integer(end));
            }
            if (errorIndexes.isEmpty()) {
                errorIndexes.add(new Integer(0));
            }
            throw new MalformedBooleanException("Expected [ ' ' ( ) || && ! true false ]", errorIndexes, booleanExpression);
        }
    }

    private static void validParenthesis(String booleanExpression) throws MalformedBooleanException {
        int length = booleanExpression.length();
        int openParenthesis = 0;
        int closeParenthesis = 0;
        int lastOpenParenthesisIndex = 0;
        block4: for (int i = 0; i < length; ++i) {
            char charAt = booleanExpression.charAt(i);
            switch (charAt) {
                case '(': {
                    lastOpenParenthesisIndex = i;
                    ++openParenthesis;
                    continue block4;
                }
                case ')': {
                    if (openParenthesis >= ++closeParenthesis) continue block4;
                    throw new MalformedBooleanException("Have a close parenthesis without an open parenthesis", i, booleanExpression);
                }
            }
        }
        if (openParenthesis > closeParenthesis) {
            throw new MalformedBooleanException("Have an open parenthesis without a close parenthesis", lastOpenParenthesisIndex, booleanExpression);
        }
    }

    private static String format(String booleanExpression) {
        String formatedBooleanExpression = booleanExpression.toUpperCase().replaceAll("TRUE", "T").replaceAll("FALSE", "F").replaceAll("\\|\\|", "|").replaceAll("&&", "&");
        return formatedBooleanExpression;
    }
}

