/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.NMS.NMSUtils;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.mechanics.AuraMechanic;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="clicklistener", author="BerndiVader")
public class ClickListenerMechanic
extends AuraMechanic
implements ITargetedEntitySkill {
    static String str = "MME_CLICKLISTENER";
    int maxDelay;
    String metaString;
    String matchString;
    boolean actionbar;
    boolean crouch;
    Optional<Skill> matchSkill = Optional.empty();
    Optional<Skill> clickSkill = Optional.empty();
    Optional<Skill> startSkill = Optional.empty();
    Optional<Skill> failSkill = Optional.empty();

    public ClickListenerMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.auraName = Optional.of(mlc.getString("buffname", str));
        String s1 = mlc.getString("startskill");
        if (s1 != null) {
            this.startSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("clickskill")) != null) {
            this.clickSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("finishskill")) != null) {
            this.matchSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        if ((s1 = mlc.getString("failskill")) != null) {
            this.failSkill = Utils.mythicmobs.getSkillManager().getSkill(s1);
        }
        this.maxDelay = mlc.getInteger("maxdelay", 10);
        this.actionbar = mlc.getBoolean("actionbar", true);
        this.crouch = mlc.getBoolean("crouch", true);
        this.metaString = mlc.getString("meta", "actionstring");
        this.matchString = mlc.getString("matchstring", new String());
    }

    public boolean castAtEntity(SkillMetadata arg0, AbstractEntity arg1) {
        if (!arg1.isPlayer()) {
            return false;
        }
        if (!arg1.getBukkitEntity().hasMetadata(str)) {
            new ClickTracker(this, arg0, (Player)arg1.getBukkitEntity());
            return true;
        }
        return false;
    }

    class ClickTracker
    extends Aura.AuraTracker
    implements Runnable,
    IParentSkill,
    Listener {
        final ClickListenerMechanic buff;
        public int ticksRemaining;
        String actionString;
        boolean hasEnded;
        boolean finish;
        boolean crouch;
        Player p;

        public ClickTracker(ClickListenerMechanic buff, SkillMetadata data, Player p) {
            SkillMetadata sd;
            Skill sk;
            super((Aura)ClickListenerMechanic.this, (AbstractEntity)BukkitAdapter.adapt((Player)p), data);
            this.buff = buff;
            this.ticksRemaining = buff.maxDelay;
            this.skillMetadata.setCallingEvent((IParentSkill)this);
            this.finish = false;
            this.hasEnded = false;
            this.crouch = ClickListenerMechanic.this.crouch;
            this.p = p;
            this.actionString = new String();
            Main.pluginmanager.registerEvents((Listener)this, (Plugin)Main.getPlugin());
            p.setMetadata(str, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)true));
            if (ClickListenerMechanic.this.startSkill.isPresent() && (sk = ClickListenerMechanic.this.startSkill.get()).isUsable(sd = data.deepClone())) {
                sk.execute(sd);
            }
            this.start();
        }

        @Override
        public void run() {
            SkillMetadata sd;
            Skill sk;
            --this.ticksRemaining;
            if (this.finish) {
                this.p.setMetadata(ClickListenerMechanic.this.metaString, (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)this.actionString));
                if (ClickListenerMechanic.this.matchSkill.isPresent() && (sk = ClickListenerMechanic.this.matchSkill.get()).isUsable(sd = this.skillMetadata.deepClone())) {
                    sk.execute(sd);
                }
                this.terminate();
            }
            if (this.skillMetadata.getCaster().getEntity().isDead() || !this.hasEnded && this.ticksRemaining < 1) {
                if (ClickListenerMechanic.this.failSkill.isPresent() && (sk = ClickListenerMechanic.this.failSkill.get()).isUsable(sd = this.skillMetadata.deepClone())) {
                    sk.execute(sd);
                }
                this.terminate();
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void clickListener(PlayerInteractEvent e) {
            if (e.getPlayer() == this.p && e.getHand() == EquipmentSlot.HAND) {
                SkillMetadata sd;
                Skill sk;
                e.setCancelled(true);
                String s1 = e.getAction().toString().split("_")[0];
                this.actionString = this.actionString + (this.actionString.isEmpty() ? s1 : "+" + s1);
                if (ClickListenerMechanic.this.clickSkill.isPresent() && (sk = ClickListenerMechanic.this.clickSkill.get()).isUsable(sd = this.skillMetadata.deepClone())) {
                    sk.execute(sd);
                }
                if (ClickListenerMechanic.this.actionbar) {
                    NMSUtils.sendActionBar(this.p, this.actionString);
                }
                this.ticksRemaining = this.buff.maxDelay;
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void shiftListener(PlayerToggleSneakEvent e) {
            if (!this.crouch) {
                return;
            }
            if (e.getPlayer() == this.p) {
                e.setCancelled(true);
                this.finish = true;
            }
        }

        public boolean getCancelled() {
            return this.hasTerminated();
        }

        public void setCancelled() {
            this.terminate();
        }

        public boolean terminate() {
            if (!this.hasEnded) {
                if (ClickListenerMechanic.this.auraName.isPresent()) {
                    this.skillMetadata.getCaster().unregisterAura((String)ClickListenerMechanic.this.auraName.get(), (Aura.AuraTracker)this);
                }
                this.hasEnded = true;
            }
            HandlerList.unregisterAll((Listener)this);
            this.p.removeMetadata(str, (Plugin)Main.getPlugin());
            this.close();
            return true;
        }
    }
}

