/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.Utils;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MobManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.MythicEntity;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@ExternalAnnotation(name="customsummon", author="BerndiVader")
public class CustomSummonMechanic
extends SkillMechanic
implements ITargetedLocationSkill,
ITargetedEntitySkill {
    MythicMob mm;
    MythicEntity me;
    String tag;
    String amount;
    int noise;
    int yNoise;
    boolean yUpOnly;
    boolean onSurface;
    boolean inheritThreatTable;
    boolean copyThreatTable;
    boolean useEyeDirection;
    boolean setowner;
    boolean invisible;
    boolean leashtocaster;
    float yaw;
    double addx;
    double addy;
    double addz;
    double inFrontBlocks;
    String reason;

    public CustomSummonMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.amount = mlc.getString(new String[]{"amount", "a"}, "1", new String[0]);
        if (this.amount.startsWith("-")) {
            this.amount = "1";
        }
        String strType = mlc.getString(new String[]{"mobtype", "type", "t", "mob", "m"}, "SKELETON", new String[0]);
        this.invisible = mlc.getBoolean(new String[]{"invisible", "inv"}, false);
        this.tag = SkillString.unparseMessageSpecialChars((String)mlc.getString(new String[]{"addtag", "tag", "at"}, "", new String[0]));
        this.noise = mlc.getInteger(new String[]{"noise", "n", "radius", "r"}, 0);
        this.yNoise = mlc.getInteger(new String[]{"ynoise", "yn", "yradius", "yr"}, this.noise);
        this.yUpOnly = mlc.getBoolean(new String[]{"yradiusuponly", "ynoiseuponly", "yruo", "ynuo", "yu"}, false);
        this.onSurface = mlc.getBoolean(new String[]{"onsurface", "os", "s"}, true);
        this.copyThreatTable = mlc.getBoolean(new String[]{"copythreattable", "ctt"}, false);
        this.inheritThreatTable = mlc.getBoolean(new String[]{"inheritthreattable", "itt"}, false);
        this.addx = mlc.getDouble(new String[]{"addx", "ax", "relx", "rx"}, 0.0);
        this.addy = mlc.getDouble(new String[]{"addy", "ay", "rely", "ry"}, 0.0);
        this.addz = mlc.getDouble(new String[]{"addz", "az", "relz", "rz"}, 0.0);
        this.yaw = mlc.getFloat("yaw", -1337.0f);
        this.useEyeDirection = mlc.getBoolean(new String[]{"useeyedirection", "eyedirection", "ued"}, false);
        this.inFrontBlocks = mlc.getDouble(new String[]{"infrontblocks", "infront", "ifb"}, 0.0);
        this.setowner = mlc.getBoolean(new String[]{"setowner", "so"}, false);
        this.leashtocaster = mlc.getBoolean(new String[]{"leashtocaster", "leash", "lc"}, false);
        this.mm = Utils.mobmanager.getMythicMob(strType);
        if (this.mm == null) {
            this.me = BukkitEntityType.getMythicEntity((String)strType);
        }
        this.reason = mlc.getString(new String[]{"customreason", "custom", "cr"}, "SUMMON", new String[0]).toUpperCase();
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation t) {
        return this.cast(data, t, null);
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        return this.cast(data, target.getLocation(), target);
    }

    private boolean cast(SkillMetadata data, AbstractLocation tl, AbstractEntity te) {
        AbstractLocation target = tl.clone();
        if (!data.getCaster().getEntity().getWorld().equals((Object)tl.getWorld())) {
            return false;
        }
        if (this.useEyeDirection) {
            target = BukkitAdapter.adapt((Location)MathUtils.getLocationInFront(BukkitAdapter.adapt((AbstractLocation)target), this.inFrontBlocks));
        }
        target.add(this.addx, this.addy, this.addz);
        int amount = MathUtils.randomRangeInt(this.amount);
        if (this.mm != null) {
            for (int i = 1; i <= amount; ++i) {
                ActiveMob ams;
                AbstractLocation l;
                AbstractLocation abstractLocation = l = this.noise > 0 ? MobManager.findSafeSpawnLocation((AbstractLocation)target, (int)this.noise, (int)this.yNoise, (int)this.mm.getMythicEntity().getHeight(), (boolean)this.yUpOnly) : target;
                if (this.yaw != -1337.0f) {
                    l.setYaw(Math.abs(this.yaw));
                }
                if ((ams = this.mm.spawn(l, data.getCaster().getLevel())) == null || ams.getEntity() == null || ams.getEntity().isDead()) continue;
                ams.getEntity().getBukkitEntity().setMetadata("SETSPAWNREASON", (MetadataValue)new FixedMetadataValue((Plugin)Main.getPlugin(), (Object)this.reason));
                if (this.leashtocaster && ams.getEntity().getBukkitEntity() instanceof Creature) {
                    Creature c = (Creature)ams.getEntity().getBukkitEntity();
                    c.setLeashHolder(data.getCaster().getEntity().getBukkitEntity());
                }
                if (this.invisible) {
                    Utils.applyInvisible((LivingEntity)ams.getEntity().getBukkitEntity(), 0L);
                }
                Utils.mythicmobs.getEntityManager().registerMob(ams.getEntity().getWorld(), ams.getEntity());
                if (this.tag.length() > 0) {
                    ams.getEntity().addScoreboardTag(new PlaceholderString(this.tag).get((PlaceholderMeta)data, te));
                }
                if (this.setowner) {
                    ams.setOwner(data.getCaster().getEntity().getUniqueId());
                }
                if (!(data.getCaster() instanceof ActiveMob)) continue;
                ActiveMob am = (ActiveMob)data.getCaster();
                ams.setParent((SkillCaster)am);
                ams.setFaction(am.getFaction());
                if (this.copyThreatTable) {
                    try {
                        ams.importThreatTable(am.getThreatTable().clone());
                        ams.getThreatTable().targetHighestThreat();
                    }
                    catch (CloneNotSupportedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (!this.inheritThreatTable || am.getThreatTable() == null) continue;
                ams.importThreatTable(am.getThreatTable());
                ams.getThreatTable().targetHighestThreat();
            }
            return true;
        }
        if (this.me != null) {
            for (int i = 1; i <= amount; ++i) {
                AbstractLocation l;
                AbstractLocation abstractLocation = l = this.noise > 0 ? MobManager.findSafeSpawnLocation((AbstractLocation)target, (int)this.noise, (int)this.yNoise, (int)this.me.getHeight(), (boolean)this.yUpOnly) : target;
                if (this.yaw != -1337.0f) {
                    l.setYaw(Math.abs(this.yaw));
                }
                this.me.spawn(l, SpawnReason.valueOf((String)this.reason));
            }
            return true;
        }
        return false;
    }
}

