/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.mythicmobsext.mechanics;

import com.gmail.berndivader.mythicmobsext.Main;
import com.gmail.berndivader.mythicmobsext.externals.ExternalAnnotation;
import com.gmail.berndivader.mythicmobsext.utils.RangedDouble;
import com.gmail.berndivader.mythicmobsext.utils.math.MathUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@ExternalAnnotation(name="push,pushto", author="BerndiVader")
public class PushCasterMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    float s;
    boolean debug;
    boolean exact;
    boolean set;
    boolean magneto;
    double reducemagnetobydistance;
    Optional<RangedDouble> clamp = Optional.empty();

    public PushCasterMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
        this.s = mlc.getFloat("speed", 1.0f);
        this.exact = mlc.getBoolean("exact", false);
        this.debug = mlc.getBoolean("debug", false);
        this.set = mlc.getBoolean("set", false);
        this.magneto = mlc.getBoolean("magneto", false);
        this.reducemagnetobydistance = mlc.getDouble(new String[]{"reducemagnetobydistance", "rmbd"}, 0.0);
        String s1 = mlc.getString("clamp", "");
        if (s1.contains("to")) {
            this.clamp = Optional.ofNullable(new RangedDouble(s1));
        }
        if (this.debug) {
            System.err.println("Push mechanic loaded with skill line: " + skill);
        }
    }

    public boolean castAtEntity(SkillMetadata data, AbstractEntity t) {
        return this.cast(data, t.getLocation(), t);
    }

    public boolean castAtLocation(SkillMetadata data, AbstractLocation l) {
        return this.cast(data, l, null);
    }

    public boolean cast(SkillMetadata data, AbstractLocation l, AbstractEntity target) {
        final Location dest = this.magneto ? data.getCaster().getEntity().getBukkitEntity().getLocation() : BukkitAdapter.adapt((AbstractLocation)l);
        final Entity caster = this.magneto && target != null ? target.getBukkitEntity() : data.getCaster().getEntity().getBukkitEntity();
        final Vector final_distance_sq = dest.toVector().subtract(caster.getLocation().toVector()).normalize();
        double speed = this.s;
        final double final_length = dest.toVector().subtract(caster.getLocation().toVector()).length();
        final int time = (int)(final_length / speed);
        if (this.exact) {
            new BukkitRunnable(){
                int ticks = 0;
                final double speed;
                {
                    this.speed = PushCasterMechanic.this.s;
                }

                public void run() {
                    ++this.ticks;
                    Vector delta_distance = dest.toVector().subtract(caster.getLocation().toVector());
                    double delta_length = delta_distance.length();
                    double delta = this.speed * MathUtils.clamp(MathUtils.lerp(0.0, final_length, delta_length), true);
                    Vector mod_delta = final_distance_sq.clone().multiply(delta);
                    caster.setVelocity(mod_delta);
                    if (PushCasterMechanic.this.debug) {
                        System.err.println("Push mechanic executed.\nWith mod vector " + delta_distance.toString());
                    }
                    if (this.ticks >= time) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)Main.getPlugin(), 1L, 1L);
        } else {
            Vector mod_delta;
            Vector distance = final_distance_sq.clone();
            if (this.magneto && this.reducemagnetobydistance != 0.0) {
                int dd = (int)Math.sqrt(MathUtils.distance3D(caster.getLocation().toVector(), dest.toVector()));
                speed = MathUtils.clamp((double)this.s - (double)this.s * ((double)dd * this.reducemagnetobydistance), 0.0, (double)this.s);
            }
            Vector vector = mod_delta = this.set ? distance.multiply(speed) : distance.multiply(speed).add(caster.getVelocity());
            if (this.clamp.isPresent() && !this.clamp.get().equals(mod_delta.length())) {
                double speed_delta = MathUtils.clamp(mod_delta.length(), this.clamp.get().getMin(), this.clamp.get().getMax());
                mod_delta = final_distance_sq.clone().multiply(speed_delta);
            }
            caster.setVelocity(mod_delta);
            if (this.debug) {
                System.err.println("Push mechanic executed.\nWith mod vector " + mod_delta.toString());
            }
        }
        return true;
    }
}

