/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobItemGenerateEvent;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.util.jnbt.CompoundTag;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.items.ItemFactory;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Optional;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class BukkitItemStack
extends ItemFactory
implements AbstractItemStack,
Cloneable {
    private MythicItem mythicItem = null;
    private int amount = 1;

    public BukkitItemStack(String type) {
        Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(type);
        if (maybeItem.isPresent()) {
            this.mythicItem = maybeItem.get();
        } else {
            Material material = Material.matchMaterial((String)type.toUpperCase());
            if (material == null) {
                throw new IllegalArgumentException("BukkitItemStack Material cannot be null (could not find material " + type + ")");
            }
            this.type(material);
        }
    }

    public BukkitItemStack(ItemStack item) {
        super(item);
    }

    public BukkitItemStack(Material material) {
        super(new ItemStack(material));
    }

    @Override
    public BukkitItemStack amount(int d) {
        if (this.mythicItem == null) {
            super.amount(d);
        }
        this.amount = d;
        return this;
    }

    @Override
    public BukkitItemStack data(int d) {
        super.durability(d);
        return this;
    }

    public BukkitItemStack colorData(DyeColor dc) {
        this.data(dc.getWoolData());
        return this;
    }

    public CompoundTag getNBT() {
        return MythicMobs.inst().getVolatileCodeHandler().getItemHandler().getNBTData(this.build());
    }

    @Override
    public ItemStack build() {
        if (this.mythicItem != null) {
            MythicMobItemGenerateEvent event = new MythicMobItemGenerateEvent(this.mythicItem, BukkitAdapter.adapt(this.mythicItem.generateItemStack(1)));
            event = Events.callAndReturn(event);
            ItemStack item = event.getItemStack();
            if (ServerVersion.isPaper()) {
                item = item.ensureServerConversions();
            }
            return item;
        }
        return super.build();
    }

    public BukkitItemStack clone() {
        return new BukkitItemStack(this.build());
    }

    public int getAmount() {
        return this.amount;
    }
}

