/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitTriggerMetadata;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitCreeper;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.BukkitTNT;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobDeathEvent;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobLootDropEvent;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.drops.IMessagingDrop;
import io.lumine.xikage.mythicmobs.drops.LootBag;
import io.lumine.xikage.mythicmobs.drops.droppables.ExperienceDrop;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.skills.damage.DamageMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.plugin.PluginModule;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitSkillTriggers
extends PluginModule<MythicMobs>
implements Listener {
    public BukkitSkillTriggers(MythicMobs plugin) {
        super(plugin);
    }

    @Override
    public void load(MythicMobs plugin) {
        Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.HIGHEST).filter(event -> !event.isCancelled()).handler(this::onCombatTrigger).bindWith(this);
    }

    @Override
    public void unload() {
    }

    public void onCombatTrigger(EntityDamageByEntityEvent event) {
        TriggeredSkill ts;
        ActiveMob am;
        ProjectileSource ps;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityDamageByEntityEvent fired for {0}", event.getFinalDamage());
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        AbstractEntity damager = event.getDamager() instanceof LivingEntity ? BukkitAdapter.adapt(event.getDamager()) : (event.getDamager() instanceof Projectile ? ((ps = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity ? BukkitAdapter.adapt((Entity)((LivingEntity)ps)) : null) : null);
        AbstractEntity damaged = event.getEntity() instanceof LivingEntity ? BukkitAdapter.adapt(event.getEntity()) : null;
        if (damaged != null && MythicMobs.inst().getMobManager().isActiveMob(damaged.getUniqueId())) {
            am = MythicMobs.inst().getMobManager().getMythicMobInstance(damaged);
            if (damager != null && MythicMobs.inst().getMobManager().isActiveMob(damager.getUniqueId())) {
                ActiveMob am2 = MythicMobs.inst().getMobManager().getMythicMobInstance(damager);
                if (am == am2 && am.isUsingDamageSkill()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Mob hit self with skill, cancelling", new Object[0]);
                    return;
                }
                if (am.getFaction() != null && am2.getFaction() != null && am.getFaction().equals(am2.getFaction())) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (am.getType().getMaxAttackableRange() > 0 && damager != null) {
                if (damaged.getLocation().distanceSquared(damager.getLocation()) > Math.pow(am.getType().getMaxAttackableRange(), 2.0)) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "Damager is out of MaxCombatRange, cancelling damage.", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            } else if (am.getType().getMaxAttackableRange() == 0) {
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "MythicMob is not attackable, cancelling damage.", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (am.hasImmunityTable()) {
                if (am.getImmunityTable().onCooldown(damager)) {
                    event.setCancelled(true);
                    return;
                }
                am.getImmunityTable().setCooldown(damager);
                Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(0), 1L);
            }
            if ((ts = new TriggeredSkill(SkillTrigger.DAMAGED, am, damager, false, meta -> BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event), new Pair[0])).getCancelled()) {
                event.setCancelled(true);
            }
            if (am.getType().getShowNameOnDamaged()) {
                event.getEntity().setCustomNameVisible(true);
            }
            if (am.getType().usesThreatTable() && damager != null && !am.getEntity().getUniqueId().equals(damager.getUniqueId()) && am.getType().getThreatTableUseDamageTaken()) {
                am.getThreatTable().threatGain(damager, event.getDamage());
            }
            if (am.getType().getEntityDamageModifiers() != null) {
                double damage = event.getDamage();
                double mod = am.getType().getEntityDamageModifiers().getOrDefault(event.getDamager().getType().toString(), 1.0);
                if (mod != 1.0) {
                    if ((damage *= mod) > 0.0) {
                        event.setDamage(damage);
                    } else if (damage == 0.0) {
                        event.setDamage(0.0);
                    } else if (damage < 0.0) {
                        event.setDamage(0.0);
                        event.setCancelled(true);
                        if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                            damaged.setHealth(damaged.getMaxHealth());
                        } else {
                            damaged.setHealth(damaged.getHealth() - damage);
                        }
                    }
                }
            }
        }
        if (damager != null && MythicMobs.inst().getMobManager().isActiveMob(damager.getUniqueId())) {
            am = MythicMobs.inst().getMobManager().getMythicMobInstance(damager);
            if (am.getOwner().isPresent() && am.getOwner().get().equals(damaged.getUniqueId())) {
                event.setCancelled(true);
                return;
            }
            if (am.isUsingDamageSkill()) {
                event.setDamage(am.getLastDamageSkillAmount());
            } else if (event.getDamager() instanceof Creeper && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Setting Creeper Custom Damage", new Object[0]);
                if (am.getDamage() != -1.0) {
                    event.setDamage(am.getDamage());
                }
            }
            if (!am.isUsingDamageSkill() && (ts = new TriggeredSkill(SkillTrigger.ATTACK, am, damaged, new Pair[0])).getCancelled()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onDamagedTrigger(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof LivingEntity) || event.getEntity() instanceof Player) {
            return;
        }
        if (MythicMobs.inst().getMobManager().isIgnoredEntity(event.getEntity().getUniqueId())) {
            return;
        }
        LivingEntity damaged = (LivingEntity)event.getEntity();
        ActiveMob am = !MythicMobs.inst().getMobManager().isActiveMob(damaged.getUniqueId()) ? MythicMobs.inst().getMobManager().registerActiveMob(BukkitAdapter.adapt((Entity)damaged)) : MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)damaged);
        if (am == null) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "MythicMob " + am.getType().getInternalName() + " took damage!", new Object[0]);
        am.signalDamaged();
        if (am.hasImmunityTable() && !(event instanceof EntityDamageByEntityEvent)) {
            if (am.getImmunityTable().onCooldown(null)) {
                event.setCancelled(true);
                MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is currently immune to damage from non-player sources!", new Object[0]);
                return;
            }
            am.getImmunityTable().setCooldown(null);
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Setting MythicMob immune to damage from non-player sources!", new Object[0]);
        }
        if (am.getType().getIsInvincible()) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "MythicMob is Invincible, canceling damage.", new Object[0]);
            event.setCancelled(true);
            return;
        }
        double damage = event.getDamage();
        if (am.getArmor() > 0.0) {
            MythicLogger.debug(MythicLogger.DebugLevel.MECHANIC, "Modifying damage based on armor: " + am.getArmor(), new Object[0]);
            damage -= am.getArmor();
            if (damage < 1.0) {
                damage = 1.0;
            }
            event.setDamage(damage);
        }
        if (am.getType().getDamageModifiers() != null) {
            DamageMetadata data;
            Optional<Object> maybeData = am.getEntity().getMetadata("skill-damage");
            String damageType = maybeData.isPresent() ? ((data = (DamageMetadata)maybeData.get()).getElement() == null ? "SKILL" : data.getElement()) : event.getCause().toString();
            double mod = am.getType().getDamageModifiers().getOrDefault(damageType.toUpperCase(), 1.0);
            if (mod != 1.0) {
                if ((damage *= mod) > 0.0) {
                    event.setDamage(damage);
                } else if (damage == 0.0) {
                    event.setDamage(0.0);
                } else if (damage < 0.0) {
                    event.setDamage(0.0);
                    event.setCancelled(true);
                    if (damaged.getHealth() - damage > damaged.getMaxHealth()) {
                        damaged.setHealth(damaged.getMaxHealth());
                    } else {
                        damaged.setHealth(damaged.getHealth() - damage);
                    }
                }
            }
        }
        if (am.hasImmunityTable()) {
            Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(0), 1L);
        } else if (am.getNoDamageTicks() != 20) {
            Schedulers.sync().runLater(() -> damaged.setNoDamageTicks(am.getNoDamageTicks()), 1L);
        }
        if (am.getType().getDigOutOfGround().booleanValue() && event.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION) {
            Location Loc = damaged.getLocation().add(0.0, 2.0, 0.0);
            damaged.teleport(Loc);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractTrigger(PlayerInteractAtEntityEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerInteractAtEntityEvent fired", new Object[0]);
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity l = e.getRightClicked();
        if (!MythicMobs.inst().getMobManager().isActiveMob(l.getUniqueId())) {
            return;
        }
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(l));
        TriggeredSkill ts = new TriggeredSkill(SkillTrigger.INTERACT, am, (AbstractEntity)BukkitAdapter.adapt(e.getPlayer()), true, new Pair[0]);
        if (ts.getCancelled() || !am.getType().getIsInteractable()) {
            e.setCancelled(true);
            if (e.getRightClicked().getType().equals((Object)EntityType.VILLAGER)) {
                Player p = e.getPlayer();
                Villager v = (Villager)e.getRightClicked();
                if (p.getOpenInventory().getTopInventory().equals(v.getInventory())) {
                    p.getOpenInventory().close();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDeathTrigger(EntityDeathEvent event) {
        boolean dropLoot = true;
        AbstractEntity killedEntity = BukkitAdapter.adapt((Entity)event.getEntity());
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(killedEntity);
        if (am != null) {
            AbstractEntity aKiller;
            MythicMob mm3 = am.getType();
            LivingEntity killer = this.getKiller(event);
            AbstractEntity abstractEntity = aKiller = killer == null ? null : BukkitAdapter.adapt((Entity)killer);
            if (killer != null && !(killer instanceof Player) && MythicMobs.inst().getMobManager().isActiveMob(killer.getUniqueId())) {
                ActiveMob amkiller = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    dropLoot = false;
                }
            }
            TriggeredSkill ts = new TriggeredSkill(SkillTrigger.DEATH, am, aKiller, new Pair[0]);
            if (mm3.getPreventOtherDrops().booleanValue()) {
                event.getDrops().clear();
                event.setDroppedExp(0);
            }
            DropMetadata metadata = new DropMetadata(am, aKiller);
            LootBag lootBag = mm3.getDropTable().generate(metadata);
            MythicMobLootDropEvent mythicLootEvent = new MythicMobLootDropEvent(am, killer, lootBag);
            Bukkit.getServer().getPluginManager().callEvent((Event)mythicLootEvent);
            int experience = 0;
            if (dropLoot) {
                HashMap<IMessagingDrop, Double> messagingDrops = new HashMap<IMessagingDrop, Double>();
                for (Drop drop : lootBag.getDrops()) {
                    if (drop instanceof IItemDrop) {
                        event.getDrops().add(BukkitAdapter.adapt(((IItemDrop)((Object)drop)).getDrop(metadata)));
                    } else if (drop instanceof ExperienceDrop) {
                        experience = (int)((double)experience + drop.getAmount());
                    } else if (drop instanceof IIntangibleDrop && aKiller != null && aKiller.isPlayer()) {
                        ((IIntangibleDrop)((Object)drop)).giveDrop(aKiller.asPlayer(), metadata);
                    }
                    if (!(drop instanceof IMessagingDrop)) continue;
                    messagingDrops.merge((IMessagingDrop)((Object)drop), drop.getAmount(), (n, o) -> n + o);
                }
                if (aKiller != null && aKiller.isPlayer() && messagingDrops.size() > 0) {
                    for (Map.Entry entry : messagingDrops.entrySet()) {
                        String message = ((IMessagingDrop)entry.getKey()).getRewardMessage(metadata, (Double)entry.getValue());
                        if (message == null) continue;
                        aKiller.asPlayer().sendMessage(message);
                    }
                }
                if (experience > 0) {
                    event.setDroppedExp(experience);
                }
            } else {
                event.setDroppedExp(0);
                event.getDrops().clear();
            }
            MythicMobDeathEvent mythicDeathEvent = new MythicMobDeathEvent(am, killer, event.getDrops());
            Bukkit.getServer().getPluginManager().callEvent((Event)mythicDeathEvent);
            am.setDead();
        } else {
            LivingEntity killerLE = this.getKiller(event);
            if (killerLE != null && MythicMobs.inst().getMobManager().isActiveMob(killerLE.getUniqueId())) {
                ActiveMob amkiller = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killerLE));
                if (!killedEntity.isPlayer() && amkiller.getType().getPreventMobKillDrops().booleanValue()) {
                    event.getDrops().clear();
                    event.setDroppedExp(0);
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL, "Killed by entity with PreventKillDrops: true, cancelling drops!", new Object[0]);
                }
            }
        }
        MythicMobs.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeDeath(killedEntity);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        AbstractPlayer entity = BukkitAdapter.adapt(event.getPlayer());
        MythicMobs.inst().getMobManager().getActiveMobsInCombat().forEach(mob -> {
            if (mob.getEntity().isValid() && mob.getType().usesThreatTable()) {
                mob.getThreatTable().observeChangeWorld(entity);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerKillTrigger(PlayerDeathEvent event) {
        ProjectileSource ps;
        EntityDamageEvent entityDamageEvent;
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "PlayerDeathEvent fired", new Object[0]);
        Player p = event.getEntity();
        Player k = p.getKiller();
        AbstractPlayer player = BukkitAdapter.adapt(p);
        if (ConfigManager.KillMessagePrefix != null && event.getDeathMessage() != null) {
            event.setDeathMessage(ConfigManager.KillMessagePrefix + event.getDeathMessage());
        }
        if (k == null && (entityDamageEvent = event.getEntity().getLastDamageCause()) != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            k = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
        }
        if (k instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)k;
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)killer));
            if (am != null) {
                TriggeredSkill ts = new TriggeredSkill(SkillTrigger.KILLPLAYER, am, (AbstractEntity)player, new Pair[0]);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km3 = am.getType().getKillMessage();
                    event.setDeathMessage(km3.get(ts.getData(), player));
                }
            }
        } else if (k instanceof Projectile && (ps = ((Projectile)k).getShooter()) instanceof LivingEntity) {
            LivingEntity shooter = (LivingEntity)ps;
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)shooter));
            if (am != null) {
                TriggeredSkill ts = new TriggeredSkill(SkillTrigger.KILLPLAYER, am, (AbstractEntity)player, new Pair[0]);
                am.incrementPlayerKills();
                if (am.getType().hasKillMessages()) {
                    PlaceholderString km4 = am.getType().getKillMessage();
                    event.setDeathMessage(km4.get(ts.getData(), player));
                }
            }
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent e) {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "EntityExplodeEvent fired", new Object[0]);
        if (e.getEntity() == null) {
            return;
        }
        if (MythicMobs.inst().getMobManager().isActiveMob(e.getEntity().getUniqueId())) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt(e.getEntity()));
            if (am.getType().getMythicEntity() instanceof BukkitCreeper) {
                LivingEntity l = (LivingEntity)e.getEntity();
                if (((BukkitCreeper)am.getType().getMythicEntity()).preventSuicide()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "MythicCreeper has preventSuicide == true, cloning creeper...", new Object[0]);
                    ActiveMob replacement = am.getType().spawn(am.getEntity().getLocation(), am.getLevel(), SpawnReason.OTHER);
                    LivingEntity ll = (LivingEntity)BukkitAdapter.adapt(replacement.getEntity());
                    ll.setMaxHealth(l.getMaxHealth());
                    ll.setHealth(l.getHealth());
                    if (l.getPassenger() != null) {
                        ll.setPassenger(l.getPassenger());
                    }
                    if (l.getVehicle() != null) {
                        l.getVehicle().setPassenger((Entity)ll);
                    }
                    Collection pe = l.getActivePotionEffects();
                    for (PotionEffect p : pe) {
                        ll.addPotionEffect(p);
                    }
                    ActiveMob am2 = MythicMobs.inst().getMobManager().getMythicMobInstance(BukkitAdapter.adapt((Entity)ll));
                    if (am2 == null) {
                        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "! Something prevented Creeper from cloning! PreventSuicide failed :(", new Object[0]);
                        return;
                    }
                    am2.setStance(am.getStance());
                    am2.importPlayerKills(am.getPlayerKills());
                    am2.importThreatTable(am.getThreatTable());
                    TriggeredSkill ts = new TriggeredSkill(SkillTrigger.EXPLODE, am, null, new Pair[0]);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                } else {
                    TriggeredSkill ts = new TriggeredSkill(SkillTrigger.EXPLODE, am, null, new Pair[0]);
                    if (ts.getCancelled()) {
                        e.setCancelled(true);
                    }
                }
            } else if (am.getType().getMythicEntity() instanceof BukkitTNT) {
                TriggeredSkill ts = new TriggeredSkill(SkillTrigger.EXPLODE, am, null, new Pair[0]);
                if (ts.getCancelled()) {
                    e.setCancelled(true);
                }
                am.setDead();
                MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            }
        }
    }

    private LivingEntity getKiller(EntityDeathEvent event) {
        EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
        if (entityDamageEvent != null && !entityDamageEvent.isCancelled() && entityDamageEvent instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (damager instanceof Projectile) {
                if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                    LivingEntity shooter = (LivingEntity)((Projectile)damager).getShooter();
                    if (shooter != null && shooter instanceof LivingEntity) {
                        return shooter;
                    }
                } else {
                    return event.getEntity().getKiller();
                }
            }
            if (damager instanceof LivingEntity) {
                return (LivingEntity)damager;
            }
        }
        return event.getEntity().getKiller();
    }
}

