/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PigZombie;

public class BukkitBabyPigZombie
extends BukkitEntityType {
    private static final int height = 1;
    private boolean angry = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.angry = mc.getBoolean("Options.Angry", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        EntityType type = ServerVersion.isAfter(MinecraftVersions.v1_15) ? EntityType.valueOf((String)"ZOMBIFIED_PIGLIN") : EntityType.valueOf((String)"PIG_ZOMBIE");
        PigZombie e = (PigZombie)this.spawnEntity(location, type, reason);
        e.setBaby(true);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        PigZombie e = (PigZombie)entity;
        e.setBaby(true);
        e.setAngry(this.angry);
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return BukkitBabyPigZombie.isInstanceOf(e);
    }

    public static boolean isInstanceOf(Entity e) {
        if (e instanceof PigZombie) {
            return ((PigZombie)e).isBaby();
        }
        return false;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

