/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BukkitChicken
extends BukkitEntityType {
    private static final int height = 1;
    private AgeableProperty ageableProperty;
    private boolean jockey = false;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.jockey = mc.getBoolean("Options.Jockey", false);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.CHICKEN, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Chicken e = (Chicken)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.jockey) {
            MythicMobs.inst().getVolatileCodeHandler().setChickenHostile(e);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Chicken;
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

