/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;
import org.bukkit.inventory.ItemStack;

public class BukkitHorse
extends BukkitEntityType {
    private static final int height = 2;
    private AgeableProperty ageableProperty;
    private String horseStyle;
    private String horseType;
    private String horseColor;
    private String horseArmor;
    private boolean horseChest;
    private boolean horseSaddled;
    private boolean horseTamed;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        this.horseArmor = mc.getString("Options.HorseArmor");
        this.horseChest = mc.getBoolean("Options.HorseCarryingChest", false);
        this.horseStyle = mc.getString("Options.HorseStyle");
        this.horseType = mc.getString("Options.HorseType");
        this.horseColor = mc.getString("Options.HorseColor");
        this.horseColor = mc.getString("Options.Color", this.horseColor);
        this.horseSaddled = mc.getBoolean("Options.HorseSaddled", false);
        this.horseSaddled = mc.getBoolean("Options.Saddled", this.horseSaddled);
        this.horseTamed = mc.getBoolean("Options.HorseTamed", false);
        this.horseTamed = mc.getBoolean("Options.Tamed", this.horseTamed);
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.HORSE, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Horse e = (Horse)entity;
        this.ageableProperty.applyProperties(entity);
        HorseInventory hi = e.getInventory();
        if (this.horseStyle != null) {
            e.setStyle(Horse.Style.valueOf((String)this.horseStyle.toUpperCase()));
        }
        if (this.horseColor != null) {
            try {
                e.setColor(Horse.Color.valueOf((String)this.horseColor.toUpperCase()));
            }
            catch (Exception ex) {
                MythicLogger.error("invalid horse color");
            }
        }
        if (this.horseTamed) {
            e.setTamed(true);
        }
        if (this.horseSaddled) {
            hi.setSaddle(new ItemStack(Material.SADDLE, 1, 0));
        }
        if (this.horseArmor != null) {
            switch (this.horseArmor) {
                case "diamond": {
                    hi.setArmor(new ItemStack(VolatileMaterial.DIAMOND_HORSE_ARMOR, 1, 0));
                    break;
                }
                case "gold": 
                case "golden": {
                    hi.setArmor(new ItemStack(VolatileMaterial.GOLDEN_HORSE_ARMOR, 1, 0));
                    break;
                }
                default: {
                    hi.setArmor(new ItemStack(VolatileMaterial.IRON_HORSE_ARMOR, 1, 0));
                }
            }
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Horse;
    }

    @Override
    public int getHeight() {
        return 2;
    }
}

