/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.EntityPropertySet;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.utils.serialize.InventorySerialization;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantProperty
implements EntityPropertySet {
    private int level;
    private boolean hasTrades = true;
    private List<MerchantRecipe> trades;

    public MerchantProperty(MythicConfig mc) {
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
            this.level = mc.getInteger("Options.TradingLevel", 1);
            this.level = mc.getInteger("Options.Level", this.level);
        }
        this.hasTrades = mc.getBoolean("Options.HasTrades", true);
        if (mc.isSet("Trades")) {
            this.trades = new ArrayList<MerchantRecipe>();
            for (MythicConfig tradeConf : mc.getNestedConfigs("Trades").values()) {
                try {
                    int amount;
                    ItemStack result;
                    String strResult = tradeConf.getString("Result", "STONE");
                    String strItem1 = tradeConf.getString("Item1", "5 EMERALD");
                    String strItem2 = tradeConf.getString("Item2", null);
                    int maxUses = tradeConf.getInteger("MaxUses", 10000);
                    String[] spResult = strResult.split(" ");
                    ItemStack itemStack = result = spResult.length == 1 ? new BukkitItemStack(spResult[0]).build() : new BukkitItemStack(spResult[1]).build();
                    if (result.getType() != Material.PLAYER_HEAD) {
                        result = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(result));
                    }
                    if (spResult.length == 2) {
                        int amount2;
                        try {
                            amount2 = Integer.parseInt(spResult[0]);
                        }
                        catch (NumberFormatException exception) {
                            amount2 = 0;
                        }
                        result.setAmount(amount2);
                    }
                    MerchantRecipe recipe = new MerchantRecipe(result, maxUses);
                    if (strItem1 != null) {
                        String[] spItem1 = strItem1.split(" ");
                        ItemStack item1 = spItem1.length == 1 ? new BukkitItemStack(spItem1[0]).build() : new BukkitItemStack(spItem1[1]).build();
                        item1 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item1));
                        if (spItem1.length == 2) {
                            try {
                                amount = Integer.parseInt(spItem1[0]);
                            }
                            catch (NumberFormatException exception) {
                                amount = 0;
                            }
                            item1.setAmount(amount);
                        }
                        recipe.addIngredient(item1);
                    }
                    if (strItem2 != null) {
                        String[] spItem2 = strItem2.split(" ");
                        ItemStack item2 = spItem2.length == 1 ? new BukkitItemStack(spItem2[0]).build() : new BukkitItemStack(spItem2[1]).build();
                        item2 = InventorySerialization.decodeItemStack(InventorySerialization.encodeItemStackToString(item2));
                        if (spItem2.length == 2) {
                            try {
                                amount = Integer.parseInt(spItem2[0]);
                            }
                            catch (NumberFormatException exception) {
                                amount = 0;
                            }
                            item2.setAmount(amount);
                        }
                        recipe.addIngredient(item2);
                    }
                    this.trades.add(recipe);
                }
                catch (Exception ex) {
                    MythicLogger.errorGenericConfig("A villager trade with result " + tradeConf.getString("Result", "STONE") + " is configured incorrectly.");
                    ex.printStackTrace();
                }
            }
        }
    }

    public boolean hasTrades() {
        return this.trades != null && !this.trades.isEmpty();
    }

    @Override
    public Entity applyProperties(Entity entity) {
        if (!(entity instanceof Merchant)) {
            return entity;
        }
        Merchant merchant = (Merchant)entity;
        if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14) && entity instanceof Villager) {
            ((Villager)entity).setVillagerLevel(this.level);
        }
        if (this.hasTrades()) {
            merchant.setRecipes(this.trades);
        } else {
            merchant.setRecipes(Collections.emptyList());
        }
        return entity;
    }
}

