/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.listeners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.EggManager;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EggListeners
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void EggEvent(PlayerInteractEvent e) {
        if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            if (e.getHand() != EquipmentSlot.HAND) {
                return;
            }
            ItemStack i = e.getItem();
            if (i == null) {
                return;
            }
            if (i.getType() != VolatileMaterial.SPAWN_EGG) {
                return;
            }
            if (!i.getItemMeta().hasLore()) {
                return;
            }
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Detected Monster Egg usage, checking for Mythic Egg...", new Object[0]);
            List list = e.getItem().getItemMeta().getLore();
            if (((String)list.get(0)).equals(ChatColor.DARK_GRAY + "" + ChatColor.ITALIC + "A Mythical Egg that can")) {
                e.setCancelled(true);
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Mythic Egg used. Attempting to spawn mob...", new Object[0]);
                final MythicMob mm3 = EggManager.getMythicMobFromEgg((String)list.get(2));
                if (mm3 == null) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "! Eggs mob type was invalid", new Object[0]);
                    return;
                }
                ItemStack eggItem = e.getItem().clone();
                if (eggItem.getAmount() > 1) {
                    eggItem.setAmount(eggItem.getAmount() - 1);
                    e.getPlayer().setItemInHand(eggItem);
                } else {
                    e.getPlayer().setItemInHand(new ItemStack(Material.AIR));
                }
                if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "| Egg was on right-clicked block. Spawning mob at block.", new Object[0]);
                    Location location = e.getClickedBlock().getLocation().clone().add(0.5, 1.0, 0.5);
                    MythicMobs.inst().getMobManager().spawnMob(mm3.getInternalName(), location);
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ Mythic Mob {0} was spawned from an egg.", mm3.getInternalName());
                } else {
                    MythicLogger.debug(MythicLogger.DebugLevel.INFO, "| Egg was thrown. Spawning mob at egg in 3 seconds...", new Object[0]);
                    Player player = e.getPlayer();
                    final Item egg = e.getPlayer().getWorld().dropItem(new Location(player.getWorld(), player.getLocation().getX(), player.getLocation().getY() + 1.4, player.getLocation().getZ()), eggItem);
                    Vector dir = player.getLocation().getDirection();
                    Vector vec = new Vector(dir.getX(), dir.getY(), dir.getZ()).multiply(1);
                    egg.setPickupDelay(Short.MAX_VALUE);
                    egg.setTicksLived(5800);
                    egg.setVelocity(vec);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MythicMobs.inst(), new Runnable(){

                        @Override
                        public void run() {
                            MythicMobs.inst().getMobManager().spawnMob(mm3.getInternalName(), egg.getLocation());
                            egg.remove();
                            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "+ Mythic Mob {0} was spawned from an egg.", mm3.getInternalName());
                        }
                    }, 50L);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void DispenseEggEvent(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DROPPER) {
            return;
        }
        ItemStack i = e.getItem();
        if (i == null) {
            return;
        }
        if (i.getType() != VolatileMaterial.SPAWN_EGG) {
            return;
        }
        if (!i.getItemMeta().hasLore()) {
            return;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Detected Monster Egg being dispensed, parsing Mythic Egg...", new Object[0]);
        List list = e.getItem().getItemMeta().getLore();
        if (((String)list.get(0)).equals(ChatColor.DARK_GRAY + "" + ChatColor.ITALIC + "A Mythical Egg that can")) {
            MythicMob mm3 = EggManager.getMythicMobFromEgg((String)list.get(2));
            if (mm3 == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- The egg's mob was invalid?", new Object[0]);
                return;
            }
            Location location = e.getBlock().getLocation().clone();
            if (e.getBlock().getData() == 8) {
                location.setY(location.getY() - 1.0);
            } else if (e.getBlock().getData() == 9) {
                location.setY(location.getY() + 1.0);
            } else if (e.getBlock().getData() == 10) {
                location.setZ(location.getZ() - 1.0);
            } else if (e.getBlock().getData() == 11) {
                location.setZ(location.getZ() + 1.0);
            } else if (e.getBlock().getData() == 12) {
                location.setX(location.getX() - 1.0);
            } else if (e.getBlock().getData() == 13) {
                location.setX(location.getX() + 1.0);
            } else {
                location.setY(location.getY() + 1.0);
            }
            MythicMobs.inst().getMobManager().spawnMob(mm3.getInternalName(), location);
            e.setCancelled(true);
            ItemStack newItem = e.getItem();
            newItem.setAmount(newItem.getAmount() - 1);
            e.setItem(newItem);
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Mythic Mob " + mm3.getInternalName() + " was spawned from a dispensed egg.", new Object[0]);
        }
    }
}

