/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KillAllCommand
extends Command<MythicMobs> {
    public KillAllCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        int radius = 0;
        boolean literally = false;
        if (args != null && args.length > 1 && args[0].startsWith("-")) {
            if (args[0].contains("p")) {
                literally = true;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length > 0 && sender instanceof Player) {
            radius = Integer.parseInt(args[0]);
        }
        if (args.length > 1 && args[1].equals("LITERALLY")) {
            literally = true;
        }
        int amount = 0;
        if (radius > 0) {
            AbstractPlayer player = BukkitAdapter.adapt((Player)sender);
            for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
                if (am.getType().isPersistent() && !literally || !am.getLocation().getWorld().equals(player.getWorld()) || !(am.getLocation().distanceSquared(player.getLocation()) <= Math.pow(radius, 2.0)) || !am.getEntity().isLoaded()) continue;
                am.setDespawned();
                MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                am.getEntity().remove();
                ++amount;
            }
        } else {
            amount = literally ? MythicMobs.inst().getMobManager().removeAllAllMobs() : MythicMobs.inst().getMobManager().removeAllMobs();
        }
        sender.sendMessage(ChatColor.GREEN + "Removed " + amount + " Mythic Mobs!");
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.killall";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "killall";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"ka"};
    }
}

