/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.utils.chat.ColorString;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class ListActiveCommand
extends Command<MythicMobs> {
    public ListActiveCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        double radius;
        MythicMob filter = null;
        double d = radius = sender instanceof Player ? Double.MAX_VALUE : -1.0;
        if (args.length > 0 && !args[0].equals("*")) {
            if (args[0].matches("[0-9]*")) {
                radius = sender instanceof Player ? Double.valueOf(args[0]) : -1.0;
            } else {
                filter = MythicMobs.inst().getMobManager().getMythicMob(args[0]);
            }
        }
        if (args.length > 1) {
            radius = sender instanceof Player ? Double.valueOf(args[1]) : -1.0;
        }
        HashMap found = new HashMap();
        for (ActiveMob activeMob : MythicMobs.inst().getMobManager().getActiveMobs()) {
            try {
                double distanceSq;
                if (filter != null && !activeMob.getType().getInternalName().equals(filter.getInternalName()) || radius > 0.0 && (distanceSq = activeMob.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation())) > Math.pow(radius, 2.0)) continue;
                if (!found.containsKey(activeMob.getType())) {
                    found.put(activeMob.getType(), new ArrayList());
                }
                ((List)found.get(activeMob.getType())).add(activeMob);
            }
            catch (Error | Exception ex) {
                sender.sendMessage(Text.colorize("&cFailed to get information on " + activeMob.getMobType() + "." + activeMob.getUniqueId()));
                if (activeMob.getEntity() == null) {
                    sender.sendMessage(Text.colorize("&7- &eEntity is null"));
                }
                if (activeMob.getType() != null) continue;
                sender.sendMessage(Text.colorize("&7- &eType is null"));
            }
        }
        if (filter != null) {
            CommandHelper.sendSuccess(sender, "ActiveMobs of Type &f" + filter.getInternalName() + " &7(" + ((List)found.get(filter)).size() + " total&7)");
        } else {
            int size = found.values().stream().mapToInt(List::size).sum();
            CommandHelper.sendSuccess(sender, "ActiveMobs Found &7(" + size + " total&7)");
        }
        for (Map.Entry entry : found.entrySet()) {
            sender.sendMessage(ColorString.get("&7- &f" + ((MythicMob)entry.getKey()).getInternalName() + " &7- &a" + ((List)entry.getValue()).size()));
            if (radius > 0.0) {
                Collections.sort((List)entry.getValue(), (am1, am2) -> {
                    double d1 = am1.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation());
                    double d2 = am2.getEntity().getBukkitEntity().getLocation().distanceSquared(((Player)sender).getLocation());
                    return (int)(d1 - d2);
                });
            }
            for (ActiveMob am : (List)entry.getValue()) {
                String x = String.valueOf(Numbers.round(am.getLocation().getX(), 2));
                String y = String.valueOf(Numbers.round(am.getLocation().getY(), 2));
                String z = String.valueOf(Numbers.round(am.getLocation().getZ(), 2));
                double d2 = Numbers.round(am.getEntity().getBukkitEntity().getLocation().distance(((Player)sender).getLocation()), 2);
                TextComponent baseMessage = new TextComponent(ColorString.get("&6+-- &f(" + x + "," + y + "," + z + ") &7- &f" + d2 + " away "));
                TextComponent tpMessage = new TextComponent(ColorString.get("&7[&aTP&7]"));
                TextComponent infoMessage = new TextComponent(ColorString.get("&7[&bInfo&7]"));
                TextComponent deleteMessage = new TextComponent(ColorString.get("&7[&cD&7]"));
                tpMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/minecraft:tp " + x + " " + y + " " + z + ""));
                infoMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mythicmobs:mythicmobs u activeinfo " + am.getUniqueId()));
                deleteMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/mythicmobs:mythicmobs u activeremove " + am.getUniqueId()));
                baseMessage.addExtra((BaseComponent)tpMessage);
                baseMessage.addExtra(" ");
                baseMessage.addExtra((BaseComponent)infoMessage);
                baseMessage.addExtra(" ");
                baseMessage.addExtra((BaseComponent)deleteMessage);
                sender.sendMessage((BaseComponent)baseMessage);
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicMobs)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.listactive";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "listactive";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"la"};
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream st = map.entrySet().stream();
        st.sorted(Comparator.comparing(e -> (Comparable)e.getValue())).forEachOrdered(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }
}

