/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.internal.platform.WorldGuardPlatform;
import com.sk89q.worldguard.protection.managers.RegionManager;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class WorldGuardSupport {
    private Plugin instance = Bukkit.getPluginManager().getPlugin("WorldGuard");
    private int pluginVersion = 0;
    private WorldGuardAdapter adapter;

    public WorldGuardSupport() {
        try (Scanner s2 = new Scanner(this.instance.getResource("plugin.yml")).useDelimiter("\\A");){
            while (s2.hasNext()) {
                String s1 = s2.nextLine();
                if (!s1.startsWith("version")) continue;
                this.pluginVersion = Integer.parseInt(s1.substring(10, 11));
                break;
            }
        }
        if (this.pluginVersion < 7) {
            try {
                this.adapter = new WorldGuardSix(this.instance);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid WorldGuard version");
            }
        } else {
            this.adapter = new WorldGuardSeven(this.instance);
        }
    }

    public boolean isLocationInRegions(AbstractLocation loc, String region) {
        return this.adapter.isLocationInRegions(loc, region);
    }

    public boolean LocationAllowsMobSpawning(Location l) {
        return true;
    }

    protected class WorldGuardSix
    implements WorldGuardAdapter {
        int version = 6;
        Class<?> class_WorldGuardPlugin;
        Class<?> class_WorldGuard;
        Class<?> class_FlagRegistry;
        Class<?> class_RegionContainer;
        Class<?> class_RegionManager;
        Class<?> class_ApplicableRegionSet;
        Class<?> class_EntityType;
        Class<?> class_Vector;
        Class<?> class_BukkitUtils;
        Method class_WorldGuardPlugin_getFlagRegistry;
        Method class_WorldGuard_getRegionContainer;
        Method class_RegionContainer_getRegionManager;
        Method class_RegionManager_getApplicableRegions;
        Method class_RegionManager_getApplicableRegionsIDs;
        Method class_RegionManager_getRegion;
        Method class_ApplicationRegionSet_getRegions;
        Method class_EntityType_getName;
        Method toVector;
        Object worldguard;
        Object flag_registry;

        public WorldGuardSix(Plugin worldguard) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.load_classes();
            this.worldguard = worldguard;
            this.flag_registry = this.class_WorldGuardPlugin.getMethod("getFlagRegistry", new Class[0]).invoke((Object)worldguard, new Object[0]);
        }

        @Override
        public boolean isLocationInRegions(AbstractLocation loc, String region) {
            Location l = BukkitAdapter.adapt(loc);
            Object region_manager = null;
            Object applicable_region_set = null;
            try {
                region_manager = this.class_RegionContainer_getRegionManager.invoke(this.class_WorldGuard_getRegionContainer.invoke(this.worldguard, new Object[0]), l.getWorld());
                if (region_manager != null) {
                    Object vector = this.toVector.invoke(null, l);
                    applicable_region_set = this.class_RegionManager_getApplicableRegionsIDs.invoke(region_manager, vector);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (applicable_region_set == null) {
                return false;
            }
            List set = (List)applicable_region_set;
            String[] regions = region.split(",");
            for (String str : set) {
                for (String r : regions) {
                    if (!r.equals(str)) continue;
                    return true;
                }
            }
            return false;
        }

        private void load_classes() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
            ClassLoader class_loader = this.getClass().getClassLoader();
            this.class_FlagRegistry = class_loader.loadClass("com.sk89q.worldguard.protection.flags.registry.FlagRegistry");
            this.class_RegionManager = class_loader.loadClass("com.sk89q.worldguard.protection.managers.RegionManager");
            this.class_ApplicableRegionSet = class_loader.loadClass("com.sk89q.worldguard.protection.ApplicableRegionSet");
            this.class_WorldGuardPlugin = class_loader.loadClass("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
            this.class_WorldGuard = this.class_WorldGuardPlugin;
            this.class_RegionContainer = class_loader.loadClass("com.sk89q.worldguard.bukkit.RegionContainer");
            this.class_RegionContainer_getRegionManager = this.class_RegionContainer.getMethod("get", World.class);
            this.class_EntityType = class_loader.loadClass("org.bukkit.entity.EntityType");
            this.class_BukkitUtils = class_loader.loadClass("com.sk89q.worldguard.bukkit.BukkitUtil");
            this.toVector = this.class_BukkitUtils.getMethod("toVector", Location.class);
            this.class_Vector = class_loader.loadClass("com.sk89q.worldedit.Vector");
            this.class_WorldGuardPlugin_getFlagRegistry = this.class_WorldGuardPlugin.getMethod("getFlagRegistry", new Class[0]);
            this.class_WorldGuard_getRegionContainer = this.class_WorldGuard.getMethod("getRegionContainer", new Class[0]);
            this.class_RegionManager_getApplicableRegions = this.class_RegionManager.getMethod("getApplicableRegions", this.class_Vector);
            this.class_RegionManager_getApplicableRegionsIDs = this.class_RegionManager.getMethod("getApplicableRegionsIDs", this.class_Vector);
            this.class_RegionManager_getRegion = this.class_RegionManager.getMethod("getRegion", String.class);
            this.class_ApplicationRegionSet_getRegions = this.class_ApplicableRegionSet.getMethod("getRegions", new Class[0]);
            this.class_EntityType_getName = this.class_EntityType.getMethod("getName", new Class[0]);
        }

        public Object getFlagRegistry() {
            return this.flag_registry;
        }

        public Object getApplicableRegions(World world, Vector vector) {
            Object region_manager = null;
            Object applicable_region_set = null;
            Object regions = null;
            try {
                region_manager = this.class_RegionContainer_getRegionManager.invoke(this.class_WorldGuard_getRegionContainer.invoke(this.worldguard, new Object[0]), this.version > 6 ? new BukkitWorld(world) : world);
                if (region_manager != null && (applicable_region_set = this.class_RegionManager_getApplicableRegions.invoke(region_manager, vector)) != null) {
                    regions = this.class_ApplicationRegionSet_getRegions.invoke(applicable_region_set, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return regions;
        }

        public Object getApplicableRegionIDs(World world, Vector vector) {
            Object region_manager = null;
            Object applicable_region_set = null;
            Object regions = null;
            try {
                region_manager = this.class_RegionContainer_getRegionManager.invoke(this.class_WorldGuard_getRegionContainer.invoke(this.worldguard, new Object[0]), this.version > 6 ? new BukkitWorld(world) : world);
                if (region_manager != null && (applicable_region_set = this.class_RegionManager_getApplicableRegions.invoke(region_manager, vector)) != null) {
                    regions = this.class_ApplicationRegionSet_getRegions.invoke(applicable_region_set, new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return regions;
        }

        public Object getRegion(World world, String region_name) {
            Object region_manager = null;
            Object region = null;
            try {
                region_manager = this.class_RegionContainer_getRegionManager.invoke(this.class_WorldGuard_getRegionContainer.invoke(this.worldguard, new Object[0]), this.version > 6 ? new BukkitWorld(world) : world);
                if (region_manager != null) {
                    region = this.class_RegionManager_getRegion.invoke(region_manager, region_name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return region;
        }

        public String class_EntityType_getName(Object entity_type) {
            String s1 = new String();
            try {
                s1 = (String)this.class_EntityType_getName.invoke(entity_type, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (s1.startsWith("minecraft:")) {
                s1 = s1.substring(10);
            }
            return s1;
        }
    }

    protected class WorldGuardSeven
    implements WorldGuardAdapter {
        private WorldGuardPlatform worldguard = WorldGuard.getInstance().getPlatform();

        public WorldGuardSeven(Plugin worldguard) {
        }

        @Override
        public boolean isLocationInRegions(AbstractLocation loc, String region) {
            Location l = BukkitAdapter.adapt(loc);
            RegionManager regionManager = this.worldguard.getRegionContainer().get(com.sk89q.worldedit.bukkit.BukkitAdapter.adapt((World)l.getWorld()));
            List set = regionManager.getApplicableRegionsIDs(com.sk89q.worldedit.bukkit.BukkitAdapter.asBlockVector((Location)l));
            String[] regions = region.split(",");
            for (String str : set) {
                for (String r : regions) {
                    if (!r.equals(str)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected static interface WorldGuardAdapter {
        public boolean isLocationInRegions(AbstractLocation var1, String var2);
    }
}

