/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IIntangibleDrop;
import io.lumine.xikage.mythicmobs.drops.IMessagingDrop;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;

public class VaultDrop
extends Drop
implements IIntangibleDrop,
IMessagingDrop {
    private PlaceholderString rewardMessage = !ConfigManager.compatVaultShowMoneyMessage ? null : PlaceholderString.of(ConfigManager.compatVaultMoneyMessageFormat);
    private boolean sendMessage = true;

    public VaultDrop(String line, MythicLineConfig config) {
        super(line, config);
        this.sendMessage = config.getBoolean(new String[]{"sendmessage", "sm"}, true);
    }

    public VaultDrop(String line, MythicLineConfig config, double amount) {
        super(line, config, amount);
    }

    @Override
    public void giveDrop(AbstractPlayer target, DropMetadata metadata) {
        if (MythicMobs.inst().getCompatibility().getVault().isPresent() && this.getAmount() > 0.0) {
            MythicMobs.inst().getCompatibility().getVault().get().giveMoney(target, this.getAmount());
        }
    }

    @Override
    public String getRewardMessage(DropMetadata meta, double amount) {
        if (this.rewardMessage == null || !this.sendMessage) {
            return null;
        }
        String message = this.rewardMessage.get(meta);
        message = message.replace("<drops.money>", String.format("%.2f", amount));
        message = message.replace("<drop.amount>", String.format("%.2f", amount));
        return message;
    }
}

