/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.PluginComponent;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.IOHandler;
import io.lumine.xikage.mythicmobs.io.IOLoader;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillAudience;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTargeter;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.audience.CustomAudience;
import io.lumine.xikage.mythicmobs.skills.auras.AuraManager;
import io.lumine.xikage.mythicmobs.skills.conditions.InvalidCondition;
import io.lumine.xikage.mythicmobs.skills.mechanics.CustomMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.DNAEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.MetaSkillMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ModifyScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleAtomEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleBoxEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleLineEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleOrbitalEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleRingEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleSphereEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.ParticleTornadoEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SendResourcePackMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SendTitleMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetBlockTypeMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetGlidingMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetGlobalScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetHealthMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetMaxHealthMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetMobScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetOwnerMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetStanceMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetTargetScoreMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SetUseGravityMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShieldMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShieldPercentMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootFireballMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.ShootSkullMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SignalMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SmokeEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SmokeSwirlEffect;
import io.lumine.xikage.mythicmobs.skills.mechanics.SpringMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SummonMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.SummonPassengerMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.VariableAddMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.VariableSetMechanic;
import io.lumine.xikage.mythicmobs.skills.mechanics.VariableSubtractMechanic;
import io.lumine.xikage.mythicmobs.skills.projectiles.Projectile;
import io.lumine.xikage.mythicmobs.util.annotations.MythicAudience;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import io.lumine.xikage.mythicmobs.util.reflections.VersionCompliantReflections;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.ConsoleColor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SkillManager
extends PluginComponent {
    private static final Map<String, Class<? extends SkillCondition>> CONDITIONS = new ConcurrentHashMap<String, Class<? extends SkillCondition>>();
    private static final Map<String, Class<? extends SkillMechanic>> MECHANICS = new ConcurrentHashMap<String, Class<? extends SkillMechanic>>();
    private static final Map<String, Class<? extends SkillTargeter>> TARGETERS = new ConcurrentHashMap<String, Class<? extends SkillTargeter>>();
    private static final Map<String, Class<? extends SkillAudience>> AUDIENCES = new ConcurrentHashMap<String, Class<? extends SkillAudience>>();
    private List<File> skillFiles;
    private IOLoader<MythicMobs> defaultSkills;
    private List<IOLoader<MythicMobs>> skillLoaders;
    private ConcurrentHashMap<String, Skill> skills = new ConcurrentHashMap();
    private List<Runnable> secondPass = new ArrayList<Runnable>();
    private AuraManager auraManager;

    public SkillManager(MythicMobs core) {
        super(core);
    }

    @Override
    public void load(MythicMobs plugin) {
        MythicLogger.log((Object)((Object)ConsoleColor.CYAN) + "LOADED");
        this.auraManager = new AuraManager(this.getPlugin(), this);
        SkillManager.loadMechanics();
        Schedulers.sync().runLater(() -> {
            if (!this.secondPass.isEmpty()) {
                this.runSecondPass();
            }
        }, 100L);
    }

    @Override
    public void unload() {
        MythicLogger.log((Object)((Object)ConsoleColor.CYAN) + "UNLOADED");
        this.auraManager.shutdown();
        Projectile.BULLET_ENTITIES.forEach(AbstractEntity::remove);
    }

    public void loadSkills() {
        this.defaultSkills = new IOLoader<MythicMobs>(MythicMobs.inst(), "ExampleSkills.yml", "Skills");
        this.skillFiles = IOHandler.getAllFiles(this.defaultSkills.getFile().getParent());
        File packsFolder = new File(this.getPlugin().getDataFolder() + System.getProperty("file.separator") + "Packs");
        if (packsFolder.exists() && packsFolder.isDirectory()) {
            for (File packFolder : packsFolder.listFiles()) {
                File confFolder;
                if (!packFolder.isDirectory() || !(confFolder = new File(packFolder.getAbsolutePath() + System.getProperty("file.separator") + "Skills")).exists() || !confFolder.isDirectory()) continue;
                this.skillFiles.addAll(IOHandler.getAllFiles(confFolder.getAbsolutePath()));
            }
        }
        this.skillLoaders = IOHandler.getSaveLoad(MythicMobs.inst(), this.skillFiles, "Skills");
        this.skills.clear();
        for (IOLoader iOLoader : this.skillLoaders) {
            for (String name : iOLoader.getCustomConfig().getConfigurationSection("").getKeys(false)) {
                String file = iOLoader.getFile().getPath();
                MythicConfig mc = new MythicConfig(name, iOLoader.getCustomConfig());
                Skill ms = new Skill(file, name, mc);
                this.skills.put(name, ms);
            }
        }
        this.runSecondPass();
    }

    public void runSecondPass() {
        while (this.secondPass.size() != 0) {
            MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Doing second pass on " + this.secondPass.size() + " skills.", new Object[0]);
            ArrayList<Runnable> run = Lists.newArrayList(this.secondPass);
            this.secondPass.clear();
            run.forEach(r -> {
                if (r != null) {
                    r.run();
                }
            });
        }
    }

    public void queueSecondPass(Runnable r) {
        this.secondPass.add(r);
    }

    public void queueAfterLoad(Runnable r) {
        Schedulers.sync().runLater(r, 5L);
    }

    public void registerSkill(String internalName, Skill skill) {
        this.skills.put(internalName, skill);
    }

    public Optional<Skill> getSkill(String internalName) {
        if (internalName == null) {
            return Optional.empty();
        }
        if (internalName.startsWith("[") && internalName.endsWith("]")) {
            internalName = internalName.substring(1, internalName.length() - 2);
            internalName = MythicLineConfig.unparseBlock(internalName);
            String[] split = internalName.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            Skill skill = new Skill(elements);
            String skillName = skill.getInternalName();
            this.skills.put(skillName, skill);
            return Optional.of(skill);
        }
        if (this.skills.containsKey(internalName)) {
            return Optional.of(this.skills.get(internalName));
        }
        return Optional.empty();
    }

    public Collection<String> getSkillNames() {
        return this.skills.keySet();
    }

    public Collection<Skill> getSkills() {
        return this.skills.values();
    }

    private static void loadMechanics() {
    }

    public ImmutableMap<String, Class<? extends SkillCondition>> getConditions() {
        return ImmutableMap.copyOf(CONDITIONS);
    }

    public ImmutableMap<String, Class<? extends SkillMechanic>> getMechanics() {
        return ImmutableMap.copyOf(MECHANICS);
    }

    public ImmutableMap<String, Class<? extends SkillTargeter>> getTargeters() {
        return ImmutableMap.copyOf(TARGETERS);
    }

    public ImmutableMap<String, Class<? extends SkillAudience>> getAudiences() {
        return ImmutableMap.copyOf(AUDIENCES);
    }

    public SkillMechanic getSkillMechanic(String skill) {
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Matching mechanic to string: {0}", skill);
        String[] s2 = skill.split(" ");
        String name = null;
        MythicLineConfig mlc = new MythicLineConfig(s2[0]);
        name = s2[0].contains("{") ? s2[0].substring(0, s2[0].indexOf("{")) : s2[0];
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "-- Matching MythicSkill type to {0}", name.toUpperCase());
        if (MECHANICS.containsKey(name.toUpperCase())) {
            Class<? extends SkillMechanic> clazz = MECHANICS.get(name.toUpperCase());
            try {
                return clazz.getConstructor(String.class, MythicLineConfig.class).newInstance(skill, mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct mechanic {0}", skill);
                e.printStackTrace();
            }
        }
        try {
            if (name.toUpperCase().startsWith("SKILL:") || name.toUpperCase().startsWith("META:")) {
                String skillName = name.split(":")[1];
                return new MetaSkillMechanic(skill, skillName, mlc);
            }
            switch (name.toUpperCase()) {
                case "SENDTITLE": 
                case "TITLE": {
                    return new SendTitleMechanic(skill, mlc);
                }
                case "SENDRESOURCEPACK": 
                case "RESOURCEPACK": {
                    return new SendResourcePackMechanic(skill, mlc);
                }
                case "SETHEALTH": 
                case "SETHP": {
                    return new SetHealthMechanic(skill, mlc);
                }
                case "SETMAXHEALTH": 
                case "SETMAXHP": {
                    return new SetMaxHealthMechanic(skill, mlc);
                }
                case "SCORE": 
                case "MODIFYSCORE": {
                    return new ModifyScoreMechanic(skill, mlc);
                }
                case "SETBLOCKTYPE": 
                case "SETBLOCK": {
                    return new SetBlockTypeMechanic(skill, mlc);
                }
                case "SETGLIDING": {
                    return new SetGlidingMechanic(skill, mlc);
                }
                case "SETGLOBALSCORE": 
                case "SGS": {
                    return new SetGlobalScoreMechanic(skill, mlc);
                }
                case "SETMOBSCORE": 
                case "SMS": {
                    return new SetMobScoreMechanic(skill, mlc);
                }
                case "SETOWNER": {
                    return new SetOwnerMechanic(skill, mlc);
                }
                case "SETTARGETSCORE": 
                case "STS": {
                    return new SetTargetScoreMechanic(skill, mlc);
                }
                case "SETSTANCE": 
                case "STANCE": {
                    return new SetStanceMechanic(skill, mlc);
                }
                case "SETUSEGRAVITY": 
                case "SETGRAVITY": {
                    return new SetUseGravityMechanic(skill, mlc);
                }
                case "SHIELD": {
                    return new ShieldMechanic(skill, mlc);
                }
                case "SHIELDPERCENT": {
                    return new ShieldPercentMechanic(skill, mlc);
                }
                case "SHOOTFIREBALL": 
                case "FIREBALL": {
                    return new ShootFireballMechanic(skill, mlc);
                }
                case "SHOOTSKULL": 
                case "SKULL": 
                case "WITHERSKULL": {
                    return new ShootSkullMechanic(skill, mlc);
                }
                case "SIGNAL": 
                case "SENDSIGNAL": {
                    return new SignalMechanic(skill, mlc);
                }
                case "SPRING": 
                case "WATER": {
                    return new SpringMechanic(skill, mlc);
                }
                case "SUMMON": 
                case "SPAWNMOBS": {
                    return new SummonMechanic(skill, mlc);
                }
                case "SUMMONPASSENGER": 
                case "PASSENGER": 
                case "SUMMONRIDER": 
                case "RIDER": {
                    return new SummonPassengerMechanic(skill, mlc);
                }
                case "VARIABLESET": 
                case "SETVARIABLE": 
                case "SETVAR": {
                    return new VariableSetMechanic(skill, mlc);
                }
                case "VARIABLEADD": 
                case "ADDVARIABLE": 
                case "ADDVAR": 
                case "INCREMENTVARIABLE": {
                    return new VariableAddMechanic(skill, mlc);
                }
                case "VARIABLESUBTRACT": 
                case "VARIABLESUB": 
                case "SUBVARIABLE": 
                case "SUBVAR": 
                case "DECREMENTVARIABLE": {
                    return new VariableSubtractMechanic(skill, mlc);
                }
                case "EFFECT:PARTICLES": 
                case "PARTICLES": 
                case "E:PARTICLES": 
                case "E:P": {
                    return new ParticleEffect(skill, mlc);
                }
                case "EFFECT:PARTICLEBOX": 
                case "PARTICLEBOX": 
                case "E:PB": 
                case "PB": {
                    return new ParticleBoxEffect(skill, mlc);
                }
                case "EFFECT:PARTICLELINE": 
                case "PARTICLELINE": 
                case "E:PL": 
                case "PL": {
                    return new ParticleLineEffect(skill, mlc);
                }
                case "EFFECT:PARTICLERING": 
                case "PARTICLERING": 
                case "E:PR": 
                case "PR": {
                    return new ParticleRingEffect(skill, mlc);
                }
                case "EFFECT:PARTICLESPHERE": 
                case "PARTICLESPHERE": 
                case "E:PS": 
                case "PS": {
                    return new ParticleSphereEffect(skill, mlc);
                }
                case "EFFECT:PARTICLETORNADO": 
                case "PARTICLETORNADO": 
                case "E:PT": {
                    return new ParticleTornadoEffect(skill, mlc);
                }
                case "EFFECT:SMOKE": 
                case "E:SMOKE": 
                case "SMOKE": {
                    return new SmokeEffect(skill, mlc);
                }
                case "EFFECT:SMOKESWIRL": 
                case "E:SMOKESWIRL": 
                case "SMOKESWIRL": {
                    return new SmokeSwirlEffect(skill, mlc);
                }
                case "EFFECT:ATOM": 
                case "ATOM": 
                case "E:ATOM": {
                    return new ParticleAtomEffect(skill, mlc);
                }
                case "EFFECT:PARTICLEORBITAL": 
                case "E:PARTICLEORBITAL": 
                case "PARTICLEORBITAL": 
                case "EFFECT:PARTICLECIRCLE": 
                case "PARTICLECIRCLE": 
                case "E:PARTICLECIRCLE": {
                    return new ParticleOrbitalEffect(skill, mlc);
                }
                case "EFFECT:DNA": 
                case "DNA": 
                case "E:DNA": {
                    return new DNAEffect(skill, mlc);
                }
            }
            return new CustomMechanic(name.toUpperCase(), skill, mlc);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to load skill line due to bad syntax: {0} ", skill);
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public void runTimerSkills(long timer) {
        for (ActiveMob am : MythicMobs.inst().getMobManager().getActiveMobs()) {
            if (am == null || am.getEntity() == null || am.getType() == null) continue;
            am.tick(timer, ConfigManager.ClockInterval);
            if (am.isDead() || am.getEntity() == null || !am.getEntity().isValid() || !am.getType().isUsingTimers()) continue;
            this.executeMobTimerSkills(am, timer);
            MythicLogger.debug(MythicLogger.DebugLevel.CLOCK, "---- Executed TIMER skills", new Object[0]);
        }
    }

    public void executeMobTimerSkills(ActiveMob am, long timer) {
        SkillMetadata data = new SkillMetadata(SkillTrigger.TIMER, am, null);
        data.setPower(am.getPower());
        for (SkillMechanic skill : am.getType().getTimerSkills()) {
            this.getPlugin().getTimingsHandler().markSkillNew(am.getType().getInternalName() + ":" + skill.line);
            if ((double)timer % ((double)skill.interval / (double)ConfigManager.ClockInterval) == 0.0 && skill.isUsableFromCaster(data)) {
                skill.execute(data);
            }
            this.getPlugin().getTimingsHandler().markSkillComplete(am.getType().getInternalName() + ":" + skill.line);
        }
    }

    public List<SkillCondition> getConditions(List<String> block) {
        ArrayList<SkillCondition> conditions = null;
        for (String s2 : block) {
            SkillCondition sc = SkillCondition.getCondition(s2 = MythicLineConfig.unparseBlock(s2));
            if (sc instanceof InvalidCondition) continue;
            if (conditions == null) {
                conditions = new ArrayList<SkillCondition>();
            }
            conditions.add(sc);
        }
        return conditions;
    }

    public List<SkillCondition> getConditions(String block) {
        if (block.startsWith("[") && block.endsWith("]")) {
            block = block.substring(1, block.length() - 2);
            block = MythicLineConfig.unparseBlock(block);
            String[] split = block.split("-");
            ArrayList<String> elements = new ArrayList<String>();
            for (String e : split) {
                if (e.trim().length() == 0) continue;
                elements.add(e.trim());
            }
            return this.getConditions(elements);
        }
        return null;
    }

    public SkillAudience getAudience(String search, MythicLineConfig mlc) {
        if (search == null) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "? Matching Audience type to " + search, new Object[0]);
        ImmutableMap<String, Class<? extends SkillAudience>> AUDIENCES = this.getPlugin().getSkillManager().getAudiences();
        if (AUDIENCES.containsKey(search.toUpperCase())) {
            Class clazz = (Class)AUDIENCES.get(search.toUpperCase());
            try {
                return (SkillAudience)clazz.getConstructor(MythicLineConfig.class).newInstance(mlc);
            }
            catch (Exception e) {
                MythicLogger.error("Failed to construct audience {0}", search);
                e.printStackTrace();
            }
        }
        return new CustomAudience(mlc);
    }

    public AuraManager getAuraManager() {
        return this.auraManager;
    }

    static {
        Set<Class<?>> conditionsClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.skills.conditions.all").getTypesAnnotatedWith(MythicCondition.class);
        for (Class<?> clazz : conditionsClasses) {
            try {
                String string = clazz.getAnnotation(MythicCondition.class).name();
                String[] stringArray = clazz.getAnnotation(MythicCondition.class).aliases();
                if (!SkillCondition.class.isAssignableFrom(clazz)) continue;
                CONDITIONS.put(string.toUpperCase(), clazz);
                for (String alias : stringArray) {
                    CONDITIONS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load condition {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> mechanicsClasses = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.skills.mechanics").getTypesAnnotatedWith(MythicMechanic.class);
        for (Class<?> clazz : mechanicsClasses) {
            try {
                String string = clazz.getAnnotation(MythicMechanic.class).name();
                String[] aliases = clazz.getAnnotation(MythicMechanic.class).aliases();
                if (!SkillMechanic.class.isAssignableFrom(clazz)) continue;
                MECHANICS.put(string.toUpperCase(), clazz);
                for (String alias : aliases) {
                    MECHANICS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception exception) {
                MythicLogger.error("Failed to load mechanic {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.skills.targeters").getTypesAnnotatedWith(MythicTargeter.class);
        for (Class<?> clazz : set) {
            try {
                String name = clazz.getAnnotation(MythicTargeter.class).name();
                String[] aliases = clazz.getAnnotation(MythicTargeter.class).aliases();
                if (!SkillTargeter.class.isAssignableFrom(clazz)) continue;
                TARGETERS.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    TARGETERS.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load targeter {0}", clazz.getCanonicalName());
            }
        }
        Set<Class<?>> set2 = new VersionCompliantReflections("io.lumine.xikage.mythicmobs.skills.audience").getTypesAnnotatedWith(MythicAudience.class);
        for (Class<?> clazz : set2) {
            try {
                String name = clazz.getAnnotation(MythicAudience.class).name();
                String[] aliases = clazz.getAnnotation(MythicAudience.class).aliases();
                if (!SkillAudience.class.isAssignableFrom(clazz)) continue;
                AUDIENCES.put(name.toUpperCase(), clazz);
                for (String alias : aliases) {
                    AUDIENCES.put(alias.toUpperCase(), clazz);
                }
            }
            catch (Exception ex) {
                MythicLogger.error("Failed to load audience {0}", clazz.getCanonicalName());
            }
        }
    }
}

