/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicConditionLoadEvent;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CustomCondition
extends SkillCondition {
    protected final String conditionName;
    protected final MythicLineConfig config;
    protected SkillCondition condition = null;
    protected boolean loaded = false;

    public CustomCondition(String condition, String line, MythicLineConfig mlc) {
        super(line);
        this.conditionName = condition;
        this.config = mlc;
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Loading CustomCondition with name " + condition, new Object[0]);
        Schedulers.sync().runLater(() -> {
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Attempting to Register CustomCondition: " + condition, new Object[0]);
            MythicConditionLoadEvent event = new MythicConditionLoadEvent(this, condition, this.config);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.getCondition().isPresent()) {
                this.condition = event.getCondition().get();
                this.loaded = true;
                MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loaded Custom Condition {0}", this.conditionName);
            } else {
                MythicLogger.errorConditionConfig(this, mlc, "Failed to load custom condition " + this.conditionName);
            }
        }, 1L);
    }

    public Optional<SkillCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public String getConditionArgument() {
        return this.conditionVar;
    }
}

