/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="DamageAmount", aliases={}, version="4.7", description="Checks the damage amount that caused the current skill tree. Only works with onDamaged trigger or aura.")
public class DamageAmountCondition
extends SkillCondition
implements ISkillMetaCondition {
    @MythicField(name="damagecause", aliases={"amount", "a"}, description="The damage cause to match")
    protected PlaceholderString amount;

    public DamageAmountCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.amount = mlc.getPlaceholderString(new String[]{"damageamount", "amount", "a"}, ">0", this.conditionVar);
    }

    @Override
    public boolean check(SkillMetadata meta) {
        if (meta.getVariables().has("damage-cause")) {
            double amount = Double.valueOf((String)meta.getVariables().get("damage-amount").get());
            return new RangedDouble(this.amount.get(meta)).equals(amount);
        }
        return false;
    }
}

