/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityComparisonCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationComparisonCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.numbers.RangedDouble;

@MythicCondition(author="Ashijin", name="distance", aliases={}, description="Whether the distance between the caster and target is within the given range")
public class DistanceCondition
extends SkillCondition
implements IEntityComparisonCondition,
ILocationComparisonCondition {
    @MythicField(name="distance", aliases={"d"}, description="The distance to match")
    protected RangedDouble distance;

    public DistanceCondition(String line, MythicLineConfig mlc) {
        super(line);
        String d = mlc.getString(new String[]{"distance", "d"}, this.conditionVar, new String[0]);
        this.distance = new RangedDouble(d, true);
    }

    @Override
    public boolean check(AbstractEntity entity, AbstractEntity target) {
        double diffSq = (float)entity.getLocation().distanceSquared(target.getLocation());
        return this.distance.equals(diffSq);
    }

    @Override
    public boolean check(AbstractLocation location, AbstractLocation target) {
        double diffSq = (float)location.distanceSquared(target);
        return this.distance.equals(diffSq);
    }
}

