/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

@MythicCondition(author="Ashijin", name="enderdragonPhase", aliases={"edragonPhase"}, description="Tests the phase of the target EnderDragon")
public class EnderDragonPhaseCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"types", "t"}, description="A list of phases to match")
    protected EnumSet<EnderDragon.Phase> phases;

    public EnderDragonPhaseCondition(String line, MythicLineConfig mlc) {
        super(line);
        String phaseStringList = mlc.getString(new String[]{"phase", "p"}, null, new String[0]);
        ArrayList<EnderDragon.Phase> collection = new ArrayList<EnderDragon.Phase>();
        if (phaseStringList != null) {
            for (String entityTypeString : phaseStringList.split(",")) {
                try {
                    collection.add(EnderDragon.Phase.valueOf((String)entityTypeString.toUpperCase()));
                }
                catch (Exception exception) {
                    MythicLogger.errorConditionConfig(this, mlc, "Couldn't parse \"" + entityTypeString + "\" as an EnderDragon Phase!");
                }
            }
        }
        this.phases = !collection.isEmpty() ? EnumSet.copyOf(collection) : EnumSet.noneOf(EnderDragon.Phase.class);
    }

    @Override
    public boolean check(AbstractEntity targetEntity) {
        Entity entity = targetEntity.getBukkitEntity();
        if (!(entity instanceof EnderDragon)) {
            return false;
        }
        EnderDragon dragon = (EnderDragon)entity;
        return this.phases.contains(dragon.getPhase());
    }
}

