/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import java.util.ArrayList;
import java.util.EnumSet;
import org.bukkit.entity.EntityType;

@MythicCondition(author="Ashijin", name="entityType", aliases={"mobtype"}, description="Tests the entity type of the target")
public class EntityTypeCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="type", aliases={"types", "t"}, description="A list of entity types to match")
    protected EnumSet<EntityType> entityTypes;

    public EntityTypeCondition(String line, MythicLineConfig mlc) {
        super(line);
        String entityTypesStringList = mlc.getString(new String[]{"types", "type", "t"}, null, this.conditionVar);
        ArrayList<EntityType> collection = new ArrayList<EntityType>();
        if (entityTypesStringList != null) {
            for (String entityTypeString : entityTypesStringList.split(",")) {
                try {
                    collection.add(EntityType.valueOf((String)entityTypeString.toUpperCase()));
                }
                catch (Exception exception) {
                    MythicLogger.errorConditionConfig(this, mlc, "Couldn't parse \"" + entityTypeString + "\" as an EntityType!");
                }
            }
        }
        this.entityTypes = !collection.isEmpty() ? EnumSet.copyOf(collection) : EnumSet.noneOf(EntityType.class);
    }

    @Override
    public boolean check(AbstractEntity targetEntity) {
        return this.entityTypes.contains(targetEntity.getBukkitEntity().getType());
    }
}

