/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import org.bukkit.event.entity.EntityDamageEvent;

@MythicCondition(author="jaylawl", name="lastDamageCause", aliases={}, version="4.5", description="Checks the target's last damage cause")
public class LastDamageCauseCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="damagecause", aliases={"cause", "c"}, description="The damage cause to match")
    protected EntityDamageEvent.DamageCause cause;

    public LastDamageCauseCondition(String line, MythicLineConfig mlc) {
        super(line);
        String c = mlc.getString(new String[]{"damagecause", "cause", "c"}, "ENTITY_ATTACK", this.conditionVar);
        try {
            this.cause = EntityDamageEvent.DamageCause.valueOf((String)c.toUpperCase());
        }
        catch (Exception ex) {
            this.cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            MythicLogger.errorConditionConfig(this, mlc, "Damage cause not found (or not supported by this version of MythicMobs");
        }
    }

    @Override
    public boolean check(AbstractEntity e) {
        if (e.isLiving()) {
            EntityDamageEvent event = e.getBukkitEntity().getLastDamageCause();
            return event != null && this.cause.equals((Object)event.getCause());
        }
        return false;
    }
}

