/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="lastSignal", aliases={}, description="Matches the last signal received by the target mob")
public class LastSignalCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="signal", aliases={"s"}, description="The signal to match")
    private final String signal;

    public LastSignalCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.signal = mlc.getString(new String[]{"signal", "s"}, "DEFAULT", this.conditionVar);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (MythicMobs.inst().getMobManager().isActiveMob(entity)) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(entity);
            return am.getLastSignal().matches(this.signal);
        }
        return false;
    }
}

