/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import java.util.UUID;
import org.bukkit.Bukkit;

@MythicCondition(author="Ashijin", name="ownerIsOnline", aliases={}, description="Checks if the owner of the target mob is online, if the owner is a player")
public class OwnerIsOnlineCondition
extends SkillCondition
implements IEntityCondition {
    public OwnerIsOnlineCondition(String line, MythicLineConfig mlc) {
        super(line);
    }

    @Override
    public boolean check(AbstractEntity target) {
        ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance(target);
        if (am == null) {
            return false;
        }
        if (am.getOwner().isPresent()) {
            return Bukkit.getPlayer((UUID)am.getOwner().get()) != null;
        }
        return false;
    }
}

