/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import org.bukkit.entity.Creature;

@MythicCondition(author="Ashijin", name="targetWithin", aliases={}, description="Tests if the target's target is within a certain distance")
public class TargetWithinCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="distance", aliases={"d"}, description="Distance to check")
    private double distance;

    public TargetWithinCondition(String line, MythicLineConfig mlc) {
        super(line);
        this.distance = Math.pow(Double.valueOf(mlc.getString(new String[]{"distance", "d"}, "0", this.conditionVar)), 2.0);
    }

    @Override
    public boolean check(AbstractEntity entity) {
        if (!entity.isCreature()) {
            return true;
        }
        Creature c = (Creature)entity.getBukkitEntity();
        if (c.getTarget() == null) {
            return false;
        }
        if (c.getTarget().getWorld().equals(c.getWorld())) {
            return c.getTarget().getLocation().distanceSquared(c.getLocation()) < this.distance;
        }
        return false;
    }
}

