/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ILocationCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.ISkillMetaCondition;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.skills.variables.VariableCondition;
import io.lumine.xikage.mythicmobs.skills.variables.VariableRegistry;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;

@MythicCondition(author="Ashijin", name="variableEquals", aliases={"variableeq", "varequals", "vareq"}, version="4.6", description="Checks if the given variable has a particular value.")
public class VariableEqualsCondition
extends VariableCondition
implements IEntityCondition,
ILocationCondition,
ISkillMetaCondition {
    @MythicField(name="value", aliases={"val", "v"}, description="The value to match")
    private PlaceholderString value;

    public VariableEqualsCondition(String line, MythicLineConfig mlc) {
        super(line, mlc);
        try {
            this.value = PlaceholderString.of(mlc.getString(new String[]{"value", "val", "v"}, null, new String[0]));
        }
        catch (Exception ex) {
            MythicLogger.errorConditionConfig(this, mlc, "Variable name must be set.");
            return;
        }
    }

    @Override
    public boolean check(AbstractEntity target) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        String compare = this.value.get(target);
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(AbstractLocation target) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, target);
        String compare = this.value.toString();
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    @Override
    public boolean check(SkillMetadata meta) {
        VariableRegistry registry = VariableEqualsCondition.getPlugin().getVariableManager().getRegistry(this.scope, meta, meta.getCaster().getEntity());
        String compare = this.value.toString();
        try {
            String value = registry.getString(this.key);
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "VariableEquals: checking {0} == {1}", compare, value);
            return value.equals(compare);
        }
        catch (Exception ex) {
            MythicLogger.error("Failed to process VariableEquals condition.");
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

