/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.conditions.all;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.drops.EquipSlot;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.items.MythicItem;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillCondition;
import io.lumine.xikage.mythicmobs.skills.conditions.IEntityCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicCondition;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.utils.version.MinecraftVersions;
import io.lumine.xikage.mythicmobs.utils.version.ServerVersion;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

@MythicCondition(author="jaylawl", name="wearing", aliases={"iswearing", "wielding", "iswielding"}, version="4.5", description="Tests what the target entity has equipped.")
public class WearingCondition
extends SkillCondition
implements IEntityCondition {
    @MythicField(name="armorslot", aliases={"slot", "s"}, description="The item slot to check")
    private EquipSlot slot;
    @MythicField(name="material", aliases={"mmitem", "m"}, description="A material or MythicItem name to check for")
    private ItemStack item;
    @MythicField(name="checklore", aliases={"cl"}, description="Whether to strictly match item lore")
    private boolean checklore;

    public WearingCondition(String line, MythicLineConfig mlc) {
        super(line);
        String s2 = mlc.getString(new String[]{"armorslot", "slot", "s"}, "HEAD", new String[0]).toUpperCase();
        String item = mlc.getString(new String[]{"material", "mat", "m", "mythicmobsitem", "mmitem", "mmi", "item"}, "DIRT", this.conditionVar);
        this.checklore = mlc.getBoolean(new String[]{"checklore", "cl"}, false);
        this.slot = EquipSlot.of(s2);
        Optional<MythicItem> maybeItem = MythicMobs.inst().getItemManager().getItem(item);
        if (maybeItem.isPresent()) {
            this.item = ((BukkitItemStack)maybeItem.get().generateItemStack(1)).build();
        } else {
            try {
                this.item = new ItemStack(Material.valueOf((String)item.toUpperCase()));
            }
            catch (Exception ex) {
                this.item = new ItemStack(Material.DIRT);
                MythicLogger.errorConditionConfig(this, mlc, "Item Type not found (or not supported by this version of MythicMobs");
            }
        }
    }

    @Override
    public boolean check(AbstractEntity e) {
        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "Checking WEARING Condition...", new Object[0]);
        ItemStack slotitem = null;
        if (e.isLiving()) {
            switch (this.slot) {
                case HEAD: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getHelmet();
                    break;
                }
                case CHEST: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getChestplate();
                    break;
                }
                case LEGS: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getLeggings();
                    break;
                }
                case FEET: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getBoots();
                    break;
                }
                case HAND: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getItemInMainHand();
                    break;
                }
                case OFFHAND: {
                    slotitem = ((LivingEntity)e.getBukkitEntity()).getEquipment().getItemInOffHand();
                    break;
                }
                case NONE: {
                    slotitem = null;
                    MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Invalid slot used: {0}", new Object[]{this.slot});
                }
            }
            if (slotitem == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Slot item was null, returning false", new Object[0]);
                return false;
            }
            ItemMeta itemMeta = this.item.getItemMeta();
            ItemMeta slotMeta = slotitem.getItemMeta();
            if (this.item instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(10);
                this.item.setItemMeta(itemMeta);
            }
            if (slotitem instanceof Damageable) {
                ((Damageable)slotMeta).setDamage(10);
                slotitem.setItemMeta(slotMeta);
            }
            if (!this.item.getType().equals((Object)slotitem.getType())) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Type doesn't match", new Object[0]);
                return false;
            }
            if (this.item.hasItemMeta() != slotitem.hasItemMeta()) {
                MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Meta state doesn't match", new Object[0]);
                return false;
            }
            if (this.item.hasItemMeta()) {
                ItemMeta meta = this.item.getItemMeta();
                ItemMeta meta2 = slotitem.getItemMeta();
                if (meta.hasDisplayName() != meta2.hasDisplayName()) {
                    MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Display doesn't match", new Object[0]);
                    return false;
                }
                if (meta.hasDisplayName() && !meta.getDisplayName().equals(meta2.getDisplayName())) {
                    MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! Display doesn't match", new Object[0]);
                    return false;
                }
                if (ServerVersion.isAfterOrEq(MinecraftVersions.v1_14)) {
                    if (meta.hasCustomModelData() != meta2.hasCustomModelData()) {
                        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! CustomModelData doesn't match", new Object[0]);
                        return false;
                    }
                    if (meta.hasCustomModelData() && meta.getCustomModelData() != meta2.getCustomModelData()) {
                        MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "! CustomModelData doesn't match", new Object[0]);
                        return false;
                    }
                }
            }
            MythicLogger.debug(MythicLogger.DebugLevel.CONDITION, "+ Item matches, returning true", new Object[0]);
            return true;
        }
        return false;
    }
}

