/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.Location;

@MythicMechanic(author="Ashijin", name="breakBlock", aliases={"blockBreak"}, description="Breaks the block at the target location")
public class BreakBlockMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    public BreakBlockMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.ASYNC_SAFE = false;
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        this.playEffect(target.getLocation());
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        this.playEffect(target);
        return true;
    }

    public void playEffect(AbstractLocation location) {
        Location l = BukkitAdapter.adapt(location);
        l.getBlock().breakNaturally();
    }
}

