/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.damage.DamagingMechanic;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderFloat;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import org.bukkit.entity.LivingEntity;

@MythicMechanic(author="Ashijin", name="consume", description="Deals damage to the target and heals the caster")
public class ConsumeMechanic
extends DamagingMechanic
implements ITargetedEntitySkill {
    protected PlaceholderFloat damage;
    protected PlaceholderFloat heal;

    public ConsumeMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.ASYNC_SAFE = false;
        this.damage = mlc.getPlaceholderFloat(new String[]{"damage", "dmg", "d"}, 1.0f, new String[0]);
        this.heal = mlc.getPlaceholderFloat(new String[]{"heal", "h"}, 1.0f, new String[0]);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead() || target.getHealth() <= 0.0) {
            return false;
        }
        LivingEntity consumer = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        this.doDamage(data.getCaster(), target, this.damage.get(data, target) * data.getPower());
        float modheal = this.heal.get(data, target) * data.getPower();
        if (consumer.getHealth() + (double)modheal >= consumer.getMaxHealth()) {
            consumer.setHealth(consumer.getMaxHealth());
        } else {
            consumer.setHealth(consumer.getHealth() + (double)modheal);
        }
        return true;
    }
}

