/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedLocationSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;

@MythicMechanic(author="Ashijin", name="look", description="Forces the caster to look at the target location")
public class LookMechanic
extends SkillMechanic
implements ITargetedEntitySkill,
ITargetedLocationSkill {
    protected boolean headOnly;
    protected boolean immediately;

    public LookMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.headOnly = mlc.getBoolean(new String[]{"headonly", "ho"}, false);
        this.immediately = mlc.getBoolean(new String[]{"immediately", "immediate", "i"}, false);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        MythicMobs.inst().getVolatileCodeHandler().lookAtEntity(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        return true;
    }

    @Override
    public boolean castAtLocation(SkillMetadata data, AbstractLocation target) {
        MythicMobs.inst().getVolatileCodeHandler().lookAtLocation(data.getCaster().getEntity(), target, this.headOnly, this.immediately);
        return true;
    }
}

