/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitTriggerMetadata;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.skills.damage.DamageMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

@MythicMechanic(author="Ashijin", name="ondamaged", description="Applies an aura to the target that triggers a skill when they take damage")
public class OnDamagedMechanic
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onDamagedSkill = Optional.empty();
    protected String onAttackSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelDamage;
    protected boolean modDamage = false;
    protected double damageSub;
    protected double damageMult;
    private Map<String, Double> damageModifiers = new HashMap<String, Double>();

    public OnDamagedMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onAttackSkillName = mlc.getString(new String[]{"ondamagedskill", "ondamaged", "od", "onhitskill", "onhit", "oh"});
        this.cancelDamage = mlc.getBoolean(new String[]{"cancelevent", "ce", "canceldamage", "cd"}, false);
        this.damageSub = mlc.getDouble(new String[]{"damagesub", "sub", "s"}, 0.0);
        this.damageMult = mlc.getDouble(new String[]{"damagemultiplier", "multiplier", "m"}, 1.0);
        PlaceholderString strDamageMod = mlc.getPlaceholderString(new String[]{"damagemodifiers", "damagemods", "damagemod"}, null, new String[0]);
        if (strDamageMod != null) {
            String[] lstDamageMod;
            for (String dm : lstDamageMod = strDamageMod.toString().split(",")) {
                try {
                    block7: {
                        try {
                            if (MythicMobs.isVolatile()) break block7;
                            EntityDamageEvent.DamageCause.valueOf((String)dm.toUpperCase());
                        }
                        catch (Error | Exception ex) {
                            MythicLogger.errorMechanicConfig(this, mlc, "Custom damage modifiers require MythicMobs Premium to use.");
                            continue;
                        }
                    }
                    String[] split = dm.split(" ");
                    String type = split[0];
                    double mod = Double.valueOf(split[1]);
                    this.damageModifiers.put(type, mod);
                }
                catch (Exception ex) {
                    MythicLogger.errorMechanicConfig(this, mlc, "Invalid syntax for DamageModifier");
                }
            }
        }
        if (this.damageSub != 0.0 || this.damageMult != 1.0 || this.damageModifiers.size() > 0) {
            this.modDamage = true;
        }
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onAttackSkillName != null) {
                this.onDamagedSkill = MythicMobs.inst().getSkillManager().getSkill(this.onAttackSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    protected double calculateDamage(AbstractEntity entity, EntityDamageByEntityEvent event) {
        DamageMetadata data;
        if (this.cancelDamage) {
            return 0.0;
        }
        double damage = event.getFinalDamage();
        Optional<Object> maybeData = entity.getMetadata("skill-damage");
        String damageType = maybeData.isPresent() ? ((data = (DamageMetadata)maybeData.get()).getElement() == null ? "SKILL" : data.getElement()) : event.getCause().toString();
        double mod = this.damageModifiers.getOrDefault(damageType.toUpperCase(), 1.0);
        return (damage - this.damageSub) * this.damageMult * mod;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnDamagedMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(EntityDamageByEntityEvent.class, EventPriority.HIGHEST).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt(event.getEntity()));
                BukkitTriggerMetadata.apply(meta, (EntityDamageEvent)event);
                if (this.executeAuraSkill(OnDamagedMechanic.this.onDamagedSkill, meta)) {
                    this.consumeCharge();
                    if (OnDamagedMechanic.this.cancelDamage) {
                        event.setCancelled(true);
                    } else if (OnDamagedMechanic.this.modDamage) {
                        double damage = OnDamagedMechanic.this.calculateDamage((AbstractEntity)this.entity.get(), (EntityDamageByEntityEvent)event);
                        event.setDamage(damage);
                    }
                }
            }));
            this.executeAuraSkill(OnDamagedMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

