/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IParentSkill;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.auras.Aura;
import io.lumine.xikage.mythicmobs.util.annotations.MythicField;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.Events;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityShootBowEvent;

@MythicMechanic(author="Ashijin", name="onbowshoot", aliases={"onshoot"}, description="Applies an aura to the target that triggers a skill when they shoot a bow")
public class OnShootMechanic
extends Aura
implements ITargetedEntitySkill {
    protected Optional<Skill> onShootSkill = Optional.empty();
    protected String onShootSkillName;
    @MythicField(name="cancelEvent", aliases={"ce"}, defValue="false", version="4.6", description="Whether or not to cancel the event that triggered the aura")
    protected boolean cancelEvent;
    @MythicField(name="forceAsPower", aliases={"fap"}, defValue="true", version="4.6", description="Whether to pass the force of the bow as the skill's power")
    protected boolean forceAsPower;

    public OnShootMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.onShootSkillName = mlc.getString(new String[]{"onshootskill", "onshoot", "os", "onbowshoot", "onbowshootskill"});
        this.cancelEvent = mlc.getBoolean(new String[]{"cancelevent", "ce"}, false);
        this.forceAsPower = mlc.getBoolean(new String[]{"forceaspower", "fap"}, true);
        MythicMobs.inst().getSkillManager().queueSecondPass(() -> {
            if (this.onShootSkillName != null) {
                this.onShootSkill = MythicMobs.inst().getSkillManager().getSkill(this.onShootSkillName);
            }
        });
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        new Tracker(data, target);
        return true;
    }

    private class Tracker
    extends Aura.AuraTracker
    implements IParentSkill,
    Runnable {
        public Tracker(SkillMetadata data, AbstractEntity entity) {
            super((Aura)OnShootMechanic.this, entity, data);
            this.start();
        }

        @Override
        public void auraStart() {
            this.registerAuraComponent(Events.subscribe(EntityShootBowEvent.class).filter(event -> event.getEntity().getUniqueId().equals(((AbstractEntity)this.entity.get()).getUniqueId())).handler(event -> {
                SkillMetadata meta = this.skillMetadata.deepClone();
                meta.setEntityTarget(BukkitAdapter.adapt((Entity)event.getEntity()));
                if (this.executeAuraSkill(OnShootMechanic.this.onShootSkill, meta)) {
                    this.consumeCharge();
                    if (OnShootMechanic.this.cancelEvent) {
                        event.setCancelled(true);
                    }
                }
            }));
            this.executeAuraSkill(OnShootMechanic.this.onStartSkill, this.skillMetadata);
        }
    }
}

