/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.IMetaSkill;
import io.lumine.xikage.mythicmobs.skills.Skill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.annotations.MythicMechanic;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import java.util.ArrayList;
import java.util.Optional;

@MythicMechanic(author="Ashijin", name="randomskill", aliases={"randommeta"}, description="Executes a random metaskill")
public class RandomSkillMechanic
extends SkillMechanic
implements IMetaSkill {
    protected ArrayList<String> skills = new ArrayList();

    public RandomSkillMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        String[] ss;
        this.target_creative = true;
        String s2 = mlc.getString(new String[]{"skills", "s", "metas", "meta", "m"});
        for (String sx : ss = s2.split(",")) {
            if (sx == null) continue;
            this.skills.add(sx.trim());
        }
    }

    @Override
    public boolean cast(SkillMetadata data) {
        ArrayList sl = (ArrayList)this.skills.clone();
        while (sl.size() > 0) {
            String skill = sl.size() > 1 ? (String)sl.get(Numbers.randomInt(sl.size())) : (String)sl.get(0);
            Optional<Skill> maybeSkill = MythicMobs.inst().getSkillManager().getSkill(skill);
            if (!maybeSkill.isPresent()) {
                sl.remove(skill);
                continue;
            }
            Skill ms = maybeSkill.get();
            if (ms.usable(data, null)) {
                ms.execute(data);
                return true;
            }
            sl.remove(skill);
        }
        return false;
    }
}

