/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import org.bukkit.Bukkit;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;

public class SetTargetScoreMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    private PlaceholderString objective;
    private int value;

    public SetTargetScoreMechanic(String skill, MythicLineConfig mlc) {
        super(skill, mlc);
        this.objective = mlc.getPlaceholderString(new String[]{"objective", "obj", "o"}, "", new String[0]);
        this.value = mlc.getInteger(new String[]{"value", "v"});
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Objective objective = scoreboard.getObjective(this.objective.get(data, target));
        if (objective == null) {
            objective = scoreboard.registerNewObjective(this.objective.get(data, target), "dummy");
        }
        if (target.isPlayer()) {
            objective.getScore(target.asPlayer().getName()).setScore(this.value);
        } else {
            objective.getScore(target.getUniqueId().toString()).setScore(this.value);
        }
        return true;
    }
}

