/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.mechanics;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.ITargetedEntitySkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;

public class ShieldPercentMechanic
extends SkillMechanic
implements ITargetedEntitySkill {
    protected static boolean noloop = false;
    protected float multiplier = 0.1f;
    protected float maxShield = 0.1f;

    public ShieldPercentMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.multiplier = (float)mlc.getDouble(new String[]{"multiplier", "m"}, 0.1);
        this.maxShield = mlc.getFloat(new String[]{"maxabsorb", "maxshield", "ma", "ms"}, this.multiplier);
    }

    @Override
    public boolean castAtEntity(SkillMetadata data, AbstractEntity target) {
        if (target.isDead()) {
            return false;
        }
        double shield = target.getMaxHealth() * (double)this.multiplier;
        double max = target.getMaxHealth() * (double)this.maxShield;
        double absorb = (double)MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().getEntityAbsorptionHearts(target) + shield;
        if (absorb < max) {
            MythicMobs.inst().getVolatileCodeHandler().getEntityHandler().setEntityAbsorptionHearts(target, (float)absorb);
        }
        return true;
    }
}

