/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.ILocationSelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BoundingBox;

@MythicTargeter(author="Ashijin", name="floorOfTargets", aliases={"floorsOfTarget", "FOT"}, description="Targets the first solid block below the inherited targets")
public class FloorOfTargetsTargeter
extends ILocationSelector {
    private int tries = 3;

    public FloorOfTargetsTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.tries = mlc.getInteger(new String[]{"tries", "t", "max", "m"}, 3);
    }

    @Override
    public HashSet<AbstractLocation> getLocations(SkillMetadata data) {
        HashSet<AbstractLocation> targets = new HashSet<AbstractLocation>();
        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeter", new Object[0]);
        if (data.getEntityTargets() != null) {
            block0: for (AbstractEntity entity : data.getEntityTargets()) {
                BoundingBox boundingBox = entity.getBukkitEntity().getBoundingBox();
                Block block = BukkitAdapter.adapt(entity.getLocation()).getBlock().getRelative(BlockFace.DOWN);
                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeter checking {0} at {1}", entity.getName(), block.getLocation().toString());
                for (int i = 0; i < this.tries; ++i) {
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT beep boop", new Object[0]);
                    if (block.getType() != Material.AIR) {
                        AbstractLocation target = this.mutate(BukkitAdapter.adapt(block.getLocation()));
                        MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeting location {0}", target);
                        targets.add(target);
                        continue block0;
                    }
                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT checking blocks in BB {0}", boundingBox.toString());
                    boundingBox = boundingBox.shift(0.0, -0.05, 0.0);
                    boundingBox = boundingBox.expand(0.333, 0.0, 0.333);
                    double minX = boundingBox.getMinX();
                    double minY = boundingBox.getMinY();
                    double minZ = boundingBox.getMinZ();
                    double maxX = boundingBox.getMaxX();
                    double maxY = boundingBox.getMaxY();
                    double maxZ = boundingBox.getMaxZ();
                    for (double lx = minX; lx <= maxX; lx += 1.0) {
                        for (double ly = minY; ly <= maxY; ly += 1.0) {
                            for (double lz = minZ; lz <= maxZ; lz += 1.0) {
                                Block checkBlock = new Location(block.getWorld(), lx, ly, lz).getBlock();
                                if (!checkBlock.isPassable()) {
                                    AbstractLocation target = this.mutate(BukkitAdapter.adapt(checkBlock.getLocation()));
                                    MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT targeting location {0}", target);
                                    targets.add(target);
                                    continue;
                                }
                                MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT Position {0} invalid", checkBlock.toString());
                            }
                        }
                    }
                    if (targets.size() > 0) continue block0;
                    block = block.getRelative(BlockFace.DOWN);
                }
            }
        } else if (data.getLocationTargets() != null) {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT checking locations", new Object[0]);
            block5: for (AbstractLocation e : data.getLocationTargets()) {
                Block block = BukkitAdapter.adapt(e).getBlock().getRelative(BlockFace.DOWN);
                for (int i = 0; i < this.tries; ++i) {
                    if (block.getType() == Material.AIR) continue;
                    targets.add(this.mutate(BukkitAdapter.adapt(block.getLocation())));
                    continue block5;
                }
            }
        } else {
            MythicLogger.debug(MythicLogger.DebugLevel.SKILL_CHECK, "@FOT inherited nothing", new Object[0]);
        }
        return targets;
    }
}

