/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.targeters;

import com.google.common.collect.Sets;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.targeters.IEntitySelector;
import io.lumine.xikage.mythicmobs.util.annotations.MythicTargeter;
import java.util.HashSet;

@MythicTargeter(author="Ashijin", name="livingInRadius", aliases={"livingEntitiesInRadius", "entitiesInRadius", "allInRadius", "EIR"}, description="Targets a point in front of the caster")
public class LivingInRadiusTargeter
extends IEntitySelector {
    private double radius;

    public LivingInRadiusTargeter(MythicLineConfig mlc) {
        super(mlc);
        this.radius = mlc.getDouble(new String[]{"radius", "r"}, 5.0);
    }

    @Override
    public HashSet<AbstractEntity> getEntities(SkillMetadata data) {
        SkillCaster am = data.getCaster();
        HashSet<AbstractEntity> targets = Sets.newHashSet();
        for (AbstractEntity p : LivingInRadiusTargeter.getPlugin().getVolatileCodeHandler().getWorldHandler().getEntitiesNearLocation(am.getLocation(), this.radius, ae -> ae.isLiving())) {
            if (p.getUniqueId().equals(am.getEntity().getUniqueId()) || !(am.getEntity().getLocation().distanceSquared(p.getLocation()) < Math.pow(this.radius, 2.0))) continue;
            targets.add(p);
        }
        return targets;
    }
}

