/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.variables;

import io.lumine.xikage.mythicmobs.skills.variables.Variable;
import io.lumine.xikage.mythicmobs.skills.variables.VariableType;
import io.lumine.xikage.mythicmobs.skills.variables.types.AbstractVariable;
import io.lumine.xikage.mythicmobs.skills.variables.types.FloatVariable;
import io.lumine.xikage.mythicmobs.skills.variables.types.IntegerVariable;
import io.lumine.xikage.mythicmobs.skills.variables.types.StringVariable;

public class VariableUtils {
    public static VariableType getType(Class<? extends Variable> clazz) {
        if (clazz.equals(IntegerVariable.class)) {
            return VariableType.INTEGER;
        }
        if (clazz.equals(FloatVariable.class)) {
            return VariableType.FLOAT;
        }
        if (clazz.equals(StringVariable.class)) {
            return VariableType.STRING;
        }
        if (clazz.equals(AbstractVariable.class)) {
            return VariableType.ABSTRACT;
        }
        throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
    }

    public static String getTypeName(Class<? extends Variable> clazz) {
        if (clazz.equals(IntegerVariable.class)) {
            return "Integer";
        }
        if (clazz.equals(FloatVariable.class)) {
            return "Float";
        }
        if (clazz.equals(StringVariable.class)) {
            return "String";
        }
        if (clazz.equals(AbstractVariable.class)) {
            return "Abstract";
        }
        throw new IllegalArgumentException("Invalid variable class (" + clazz.getName() + ").");
    }

    public static Class<? extends Variable> getTypeClass(String type) {
        switch (type) {
            case "Integer": {
                return IntegerVariable.class;
            }
            case "Float": {
                return FloatVariable.class;
            }
            case "String": {
                return StringVariable.class;
            }
            case "Abstract": {
                return AbstractVariable.class;
            }
        }
        throw new IllegalArgumentException("Invalid variable type : " + type + ".");
    }
}

