/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.spawning.spawners;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitWorld;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.legacy.conditions.SCondition;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderInt;
import io.lumine.xikage.mythicmobs.spawning.spawners.SpawnerManager;
import io.lumine.xikage.mythicmobs.utils.collections.WeightedCollection;
import io.lumine.xikage.mythicmobs.utils.collections.WeightedEntry;
import io.lumine.xikage.mythicmobs.utils.numbers.Numbers;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomInt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.World;

public class MythicSpawner
implements Cloneable {
    private MythicConfig config;
    private boolean active = true;
    private boolean ready = true;
    private String name;
    private String group;
    private String strMobTypes;
    private AbstractLocation location;
    private String world;
    private int blockX;
    private int blockY;
    private int blockZ;
    private boolean useTimer = true;
    private long spawnCooldownMillis = 0L;
    private long spawnCooldownTimer = 0L;
    private long spawnWarmupMillis = 4L;
    private long spawnWarmupTimer = 0L;
    private int spawnRadius = 0;
    private int spawnRadiusY = 0;
    private PlaceholderInt maxMobs = PlaceholderInt.of("1");
    private int mobsPerSpawn = 1;
    private RandomInt mobLevel = new RandomInt(1);
    private boolean showFlames = false;
    private boolean breakable = false;
    private boolean checkForPlayers = true;
    private int activationRange = 40;
    private double scalingRange = 25.0;
    private int leashRange = 32;
    private boolean healOnLeash = false;
    private boolean leashResetsThreat = false;
    private ArrayList<String> conditions = new ArrayList();
    protected int cachedActiveMobs = 0;
    private Collection<UUID> mobs = Collections.newSetFromMap(new ConcurrentHashMap());
    private transient WeightedCollection<WeightedEntry> mobTypes = new WeightedCollection();
    private transient int leashTimer = 0;
    private transient int internalCooldown = 8;
    private transient int mobHeight = 0;

    public MythicSpawner(String name, AbstractLocation location, String mobName) {
        this.name = name;
        this.strMobTypes = mobName;
        this.setType(this.strMobTypes);
        MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob(this.strMobTypes);
        if (mm3 == null && this.location == null) {
            MythicLogger.error("Error enabling spawner '{0}' - MobType '{1}' is invalid! Spawner cannot initialize. Disabling.", this.name, this.strMobTypes);
            this.Disable();
        }
        this.mobHeight = mm3.getMythicEntity() != null ? mm3.getMythicEntity().getHeight() : 2;
        this.location = location;
        this.world = location.getWorld().getName();
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.spawnRadius = 0;
        if (this.location == null) {
            MythicLogger.error("Location data for spawner '{0}' is invalid! Spawner cannot be attached to world. Disabling.", this.name);
            this.Disable();
        }
        this.spawnCooldownTimer = System.currentTimeMillis();
        this.spawnWarmupTimer = System.currentTimeMillis();
    }

    public MythicSpawner(String name, MythicConfig config) {
        this.name = name;
        this.config = config;
        this.group = config.getString("SpawnerGroup");
        this.strMobTypes = config.getString("MobName");
        this.setType(this.strMobTypes);
        this.world = config.getString("World");
        this.blockX = config.getInt("X");
        this.blockY = config.getInt("Y");
        this.blockZ = config.getInt("Z");
        this.spawnRadius = config.getInt("Radius", 0);
        this.spawnRadiusY = config.getInt("RadiusY", 0);
        this.useTimer = config.getBoolean("UseTimer", true);
        this.maxMobs = config.getPlaceholderInt("MaxMobs", "-1");
        this.mobsPerSpawn = config.getInt("MobsPerSpawn", 1);
        this.setCooldownSeconds(config.getInt("Cooldown", 0));
        this.setRemainingCooldownSeconds(config.getInt("CooldownTimer", 0));
        this.setWarmupSeconds(config.getInt("Warmup", 0));
        this.setRemainingWarmupSeconds(config.getInt("WarmupTimer", 0));
        this.activationRange = config.getInt("ActivationRange", 40);
        this.leashRange = config.getInt("LeashRange", 0);
        this.healOnLeash = config.getBoolean("HealOnLeash", false);
        this.leashResetsThreat = config.getBoolean("ResetThreatOnLeash", false);
        String mobLevel = config.getString("MobLevel", "1");
        this.setBreakable(config.getBoolean("Breakable", false));
        this.checkForPlayers = config.getBoolean("CheckForPlayers", true);
        boolean showFlames = config.getBoolean("ShowFlames", false);
        List<String> strConditions = config.getStringList("Conditions");
        int activeMobs = config.getInteger("ActiveMobs", 0);
        ArrayList<String> conditions = new ArrayList<String>();
        for (String c : strConditions) {
            conditions.add(c);
        }
        if (this.spawnRadius < 0) {
            this.spawnRadius = 0;
        }
        if (this.spawnRadiusY < 1) {
            this.spawnRadiusY = 1;
        }
        if (this.getRemainingWarmupSeconds() > 0 || this.getRemainingCooldownSeconds() > 0) {
            this.ready = false;
        }
    }

    public MythicSpawner(String name, String group, String mobName, String world, int x, int y, int z, int radius, int radiusY, boolean useTimer, PlaceholderInt maxMobs, int mps, String moblevel, int cooldown, int cooldownTimer, int warmup, int warmupTimer, int activeRange, double scalingRange, int leashRange, boolean leashHeal, boolean leashResetThreat, boolean showFlames, boolean breakable, int activeMobs, boolean checkForPlayers, ArrayList<String> conditions) {
        AbstractWorld w;
        MythicLogger.debug(MythicLogger.DebugLevel.INFO, "Loading spawner: " + name + "", new Object[0]);
        this.name = name;
        this.group = group;
        this.strMobTypes = mobName;
        this.setType(this.strMobTypes);
        try {
            w = new BukkitWorld(world);
        }
        catch (IllegalArgumentException ex) {
            w = BukkitAdapter.adapt((World)Bukkit.getWorlds().get(0));
        }
        this.location = new AbstractLocation(w, x, y, z);
        this.world = world;
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.spawnRadius = radius;
        this.spawnRadiusY = radiusY;
        this.useTimer = useTimer;
        this.maxMobs = maxMobs;
        this.mobsPerSpawn = mps;
        this.mobLevel = new RandomInt(moblevel);
        this.setCooldownSeconds(cooldown);
        this.setRemainingCooldownSeconds(cooldownTimer);
        this.setWarmupSeconds(warmup);
        this.setRemainingWarmupSeconds(warmupTimer);
        this.showFlames = showFlames;
        this.activationRange = activeRange;
        this.scalingRange = scalingRange;
        this.leashRange = leashRange;
        this.healOnLeash = leashHeal;
        this.leashResetsThreat = leashResetThreat;
        this.cachedActiveMobs = activeMobs;
        this.conditions = conditions;
        this.setBreakable(breakable);
        this.checkForPlayers = checkForPlayers;
        if (this.spawnRadius < 0) {
            this.spawnRadius = 0;
        }
        if (this.spawnRadiusY < 1) {
            this.spawnRadiusY = 1;
        }
        this.mobHeight = 1;
        for (WeightedEntry type : this.mobTypes.getView()) {
            MythicMob mm3 = MythicMobs.inst().getMobManager().getMythicMob((String)type.getValue());
            if (mm3 == null) {
                MythicLogger.error("Error enabling spawner {0} - MobType {1} is invalid! Spawner cannot initialize. Disabling.", this.name, this.strMobTypes);
                this.Disable();
                return;
            }
            int height = mm3.getMythicEntity() == null ? 2 : mm3.getMythicEntity().getHeight();
            this.mobHeight = height > this.mobHeight ? height : this.mobHeight;
        }
        if (this.location == null) {
            MythicLogger.error("Location data for spawner {0} is invalid! Spawner cannot be attached to world. Disabling.", this.name);
            this.Disable();
        }
        if (this.getRemainingWarmupSeconds() > 0 || this.getRemainingCooldownSeconds() > 0) {
            this.ready = false;
        }
    }

    public void unloadSpawner() {
        this.mobs.removeIf(uuid -> {
            Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob((UUID)uuid);
            if (maybeMob.isPresent()) {
                ActiveMob am = maybeMob.get();
                if (!am.getType().isPersistent() && am.getType().getDespawns()) {
                    if (!am.isDead() && am.getEntity().isValid()) {
                        ++this.cachedActiveMobs;
                        am.getEntity().remove();
                        MythicMobs.inst().getMobManager().unregisterActiveMob(am);
                    }
                } else {
                    return false;
                }
            }
            return true;
        });
        this.internalCooldown = 10;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getTypeName() {
        return this.strMobTypes;
    }

    public boolean setType(String type) {
        String[] split = type.split(",");
        try {
            for (String s2 : split) {
                double weight;
                String mobType;
                String[] split2;
                if (s2.contains("%")) {
                    split2 = s2.split("%");
                    mobType = split2[1];
                    weight = Double.valueOf(split2[0]) / 100.0;
                } else if (s2.contains(" ")) {
                    split2 = s2.split(" ");
                    mobType = split2[0];
                    weight = Double.valueOf(split2[1]);
                } else {
                    mobType = s2;
                    weight = 1.0;
                }
                this.mobTypes.add(new WeightedEntry<String>(mobType, weight));
            }
        }
        catch (Exception ex) {
            if (ConfigManager.debugLevel > 0) {
                ex.printStackTrace();
            }
            return false;
        }
        this.strMobTypes = type;
        return true;
    }

    public void setType(MythicMob type) {
        this.mobTypes.clear();
        this.mobTypes.add(new WeightedEntry<String>(type.getInternalName(), 1.0));
    }

    public void setTypes(Collection<MythicMob> types) {
        this.mobTypes.clear();
        for (MythicMob mm3 : types) {
            this.mobTypes.add(new WeightedEntry<String>(mm3.getInternalName(), 1.0));
        }
    }

    public void setTypes(WeightedCollection types) {
        this.mobTypes = types;
    }

    public void setLocation(AbstractLocation location) {
        this.location = location;
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.world = location.getWorld().getName();
    }

    public String getWorldName() {
        return this.world;
    }

    public void setWorld(String worldName) {
        this.world = worldName;
    }

    public void setOnCooldown() {
        this.spawnCooldownTimer = System.currentTimeMillis();
    }

    public boolean isOnCooldown() {
        return this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis() > 0L;
    }

    public int getCooldownSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis);
    }

    public void setCooldownSeconds(int cooldown) {
        this.spawnCooldownMillis = TimeUnit.SECONDS.toMillis(cooldown);
    }

    public int getRemainingCooldownSeconds() {
        if (this.isOnCooldown()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnCooldownMillis + this.spawnCooldownTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingCooldownSeconds(long seconds) {
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public void setOnWarmup() {
        this.spawnWarmupTimer = System.currentTimeMillis();
    }

    public boolean isOnWarmup() {
        return this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis() > 0L;
    }

    public int getWarmupSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis);
    }

    public void setWarmupSeconds(int warmup) {
        this.spawnWarmupMillis = TimeUnit.SECONDS.toMillis(warmup);
    }

    public int getRemainingWarmupSeconds() {
        if (this.isOnWarmup()) {
            return (int)Math.abs(TimeUnit.MILLISECONDS.toSeconds(this.spawnWarmupMillis + this.spawnWarmupTimer - System.currentTimeMillis()));
        }
        return 0;
    }

    public void setRemainingWarmupSeconds(long seconds) {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis + TimeUnit.SECONDS.toMillis(seconds);
    }

    public boolean getUseTimer() {
        return this.useTimer;
    }

    public void setUseTimer(boolean bool) {
        this.useTimer = bool;
    }

    public List<String> getConditionList() {
        return this.conditions;
    }

    public Collection<UUID> getAssociatedMobs() {
        return this.mobs;
    }

    public void setAssociatedMobs(Collection<UUID> collection) {
        this.mobs = collection;
    }

    public int getInternalCooldown() {
        return this.internalCooldown;
    }

    public void setInternalCooldown(int ic) {
        this.internalCooldown = ic;
    }

    public void tickSpawnerClock() {
        --this.internalCooldown;
        boolean spawn = true;
        if (this.isOnCooldown() || this.isOnWarmup()) {
            spawn = false;
            this.ready = false;
        } else if (!this.useTimer) {
            spawn = false;
        }
        if (!this.active) {
            return;
        }
        if (this.internalCooldown <= 1) {
            if (!(this.location != null && Bukkit.getWorld((String)this.world) != null || this.reattachToWorld())) {
                this.internalCooldown = 8;
                return;
            }
            if (!this.location.isLoaded()) {
                this.internalCooldown = 5;
                return;
            }
            if (this.checkForPlayers && !SpawnerManager.playerWithinSpawnerRange(this.activationRange, this.location)) {
                this.internalCooldown = 4;
                return;
            }
            if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
                this.cleanMobList();
                if (this.isOnWarmup()) {
                    return;
                }
            }
        } else if (this.internalCooldown > 1) {
            return;
        }
        if (this.leashRange > 0) {
            ++this.leashTimer;
            if (this.leashTimer >= 2) {
                this.Leash();
                this.leashTimer = 0;
            }
        }
        if (this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (this.cachedActiveMobs > 0) {
            while (this.cachedActiveMobs > 0) {
                this.Spawn();
                --this.cachedActiveMobs;
            }
            return;
        }
        if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
            return;
        }
        if (spawn && this.useTimer && !ConfigManager.debugMode && this.checkSpawnConditions()) {
            Collection<ActiveMob> spawns = this.Spawn();
            for (ActiveMob am : spawns) {
                new TriggeredSkill(SkillTrigger.READY, am, null, new Pair[0]);
            }
        }
    }

    public void ActivateSpawner() {
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Activating spawner {0}", this.getInternalName());
        if (this.location.getWorld() == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner world is unloaded.", new Object[0]);
            return;
        }
        if (ConfigManager.debugLevel > 0 || this.showFlames) {
            BukkitAdapter.adapt(this.location).getWorld().playEffect(BukkitAdapter.adapt(this.location), Effect.MOBSPAWNER_FLAMES, 0);
        }
        if (!this.active || this.isOnCooldown() || this.isOnWarmup()) {
            return;
        }
        if (this.maxMobs.get(this) <= this.getNumberOfMobs()) {
            if (this.cleanMobList()) {
                if (this.spawnWarmupMillis > 0L) {
                    this.setOnWarmup();
                    return;
                }
            } else {
                return;
            }
        }
        if (this.checkSpawnConditions()) {
            Collection<ActiveMob> spawns = this.Spawn();
            for (ActiveMob am : spawns) {
                new TriggeredSkill(SkillTrigger.READY, am, null, new Pair[0]);
            }
        }
    }

    public boolean checkSpawnConditions() {
        if (this.conditions != null) {
            for (String strCondition : this.conditions) {
                String[] split = strCondition.split(" ");
                String conditionData = split.length == 1 ? null : split[1];
                try {
                    if (SCondition.getSpawningConditionByName(split[0]).check(BukkitAdapter.adapt(this.location), null, conditionData)) continue;
                    return false;
                }
                catch (Exception e) {
                    MythicLogger.error("A spawning condition appears to be invalid: {0}", strCondition);
                }
            }
        }
        return true;
    }

    public Collection<ActiveMob> Spawn() {
        if (!this.active) {
            return null;
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner " + this.name + " Spawn() called. Spawning mobs...", new Object[0]);
        if (this.cachedActiveMobs == 0) {
            this.setOnCooldown();
        }
        AbstractLocation loc = new AbstractLocation(this.location.getWorld(), this.location.getX() + 0.5, this.location.getY() + 1.0, this.location.getZ() + 0.5);
        boolean good = false;
        int j = 25;
        ArrayList<ActiveMob> mobs = new ArrayList<ActiveMob>();
        for (int i = this.mobsPerSpawn; i > 0 && this.maxMobs.get(this) > this.getNumberOfMobs(); --i) {
            ActiveMob am;
            if (this.spawnRadius > 0 || this.spawnRadiusY > 1) {
                j = 25;
                good = false;
                while (!good) {
                    int nx = this.location.getBlockX() - this.spawnRadius + Numbers.randomInt(this.spawnRadius * 2);
                    int nz = this.location.getBlockZ() - this.spawnRadius + Numbers.randomInt(this.spawnRadius * 2);
                    int ny = this.spawnRadiusY > 0 ? this.location.getBlockY() - this.spawnRadiusY + Numbers.randomInt(this.spawnRadiusY * 2) : this.location.getBlockY() + 1;
                    good = true;
                    for (int k = 0; k < this.mobHeight + 1; ++k) {
                        loc = new AbstractLocation(this.location.getWorld(), nx, ny + k, nz);
                        if (!BukkitAdapter.adapt(loc).getBlock().getType().isSolid()) continue;
                        good = false;
                    }
                    if (good) {
                        loc = new AbstractLocation(this.location.getWorld(), nx, ny, nz);
                    } else {
                        if (--j != 0) continue;
                        loc = new AbstractLocation(this.location.getWorld(), loc.getBlockX(), loc.getBlockY() + 1, loc.getBlockZ());
                    }
                    break;
                }
            } else {
                loc = new AbstractLocation(this.location.getWorld(), this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
                loc = loc.add(0.0, 1.0, 0.0);
            }
            try {
                String nextType = (String)this.mobTypes.get().getValue();
                am = MythicMobs.inst().getMobManager().spawnMob(nextType, loc.add(0.5, 0.0, 0.5), SpawnReason.SPAWNER, this.mobLevel.get());
            }
            catch (Error | Exception ex) {
                am = null;
                MythicLogger.errorGenericConfig("Failed to spawn mob for Spawner '" + this.name + "'. Enable debugging for more info.");
                this.setRemainingCooldownSeconds(5L);
                if (ConfigManager.debugLevel > 0) {
                    ex.printStackTrace();
                }
                return mobs;
            }
            if (am == null) {
                MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "-- Spawner " + this.name + " failed to spawn mob: SpawnMythicMob returned null.", new Object[0]);
                return mobs;
            }
            this.mobs.add(am.getUniqueId());
            am.setSpawner(this);
            mobs.add(am);
        }
        MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "-- Spawner spawned mob(s). Number of mobs tied to spawner now: {0}", this.getNumberOfMobs());
        return mobs;
    }

    public void Leash() {
        if (this.leashRange < 1) {
            return;
        }
        for (UUID uuid : this.mobs) {
            Optional<ActiveMob> maybeMob = MythicMobs.inst().getMobManager().getActiveMob(uuid);
            if (!maybeMob.isPresent() || maybeMob.get().getEntity() == null) continue;
            ActiveMob am = maybeMob.get();
            if (am.getLocation().getWorld().equals(this.location.getWorld())) {
                if (!(this.location.distanceSquared(am.getEntity().getLocation()) > Numbers.square(this.leashRange))) continue;
                if (am.getEntity().getVehicle() != null) {
                    AbstractEntity l = am.getEntity();
                    while (l.getVehicle() != null) {
                        if (this.healOnLeash && l.isLiving()) {
                            l.setHealth(l.getMaxHealth());
                        }
                        if (this.leashResetsThreat) {
                            MythicMobs.inst().getMobManager().getMythicMobInstance(l).resetTarget();
                        }
                        l = l.getVehicle();
                    }
                }
                this.doLeash(am);
                continue;
            }
            this.doLeash(am);
        }
    }

    public void doLeash(ActiveMob am) {
        AbstractLocation spawnLocation = this.location.clone().add(0.5, 1.0, 0.5);
        am.getEntity().teleport(spawnLocation);
        if (this.healOnLeash && am.getEntity().isLiving()) {
            am.getEntity().setHealth(am.getEntity().getMaxHealth());
        }
        if (this.leashResetsThreat) {
            am.resetTarget();
        }
    }

    private boolean cleanMobList() {
        return this.mobs.removeIf(uuid -> {
            if (!MythicMobs.inst().getMobManager().isActiveMob((UUID)uuid)) {
                return true;
            }
            ActiveMob am = MythicMobs.inst().getMobManager().getActiveMob((UUID)uuid).get();
            if (am.isDead()) {
                if (this.getNumberOfMobs() >= this.maxMobs.get(this)) {
                    this.setOnWarmup();
                }
                return true;
            }
            return false;
        });
    }

    public void trackMob(ActiveMob am) {
        this.mobs.add(am.getUniqueId());
    }

    public void markMobDespawned(ActiveMob am) {
        this.mobs.remove(am.getUniqueId());
    }

    public void markMobDead(ActiveMob am) {
        if (this.mobs.contains(am.getUniqueId())) {
            if (this.getNumberOfMobs() >= this.maxMobs.get(this)) {
                this.setOnWarmup();
            }
            this.mobs.remove(am.getUniqueId());
        }
    }

    public boolean reattachToWorld() {
        if (Bukkit.getWorld((String)this.world) == null) {
            return false;
        }
        this.location = new AbstractLocation(BukkitAdapter.adapt(Bukkit.getWorld((String)this.world)), this.blockX, this.blockY, this.blockZ);
        if (this.location == null) {
            MythicLogger.debug(MythicLogger.DebugLevel.EVENT, "Spawner {0} has an invalid location and could not be reattached to world. Perhaps the world is unloaded?", this.name);
            return false;
        }
        return true;
    }

    public String getInternalName() {
        return this.name;
    }

    public int getNumberOfMobs() {
        return this.mobs.size() + this.cachedActiveMobs;
    }

    public void Disable() {
        this.active = false;
    }

    public void Enable() {
        this.active = true;
    }

    public double distanceTo(AbstractLocation abstractLocation) {
        return abstractLocation.distance(this.location);
    }

    public MythicSpawner clone() throws CloneNotSupportedException {
        return (MythicSpawner)super.clone();
    }

    public void resetTimers() {
        this.spawnWarmupTimer = System.currentTimeMillis() - this.spawnWarmupMillis;
        this.spawnCooldownTimer = System.currentTimeMillis() - this.spawnCooldownMillis;
    }

    public int getChunkX() {
        return this.blockX >> 4;
    }

    public int getChunkZ() {
        return this.blockZ >> 4;
    }

    public String getChunkString() {
        return this.world + "-" + this.getChunkX() + "-" + this.getChunkZ();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getNumberOfCachedMobs() {
        return this.cachedActiveMobs;
    }

    public AbstractLocation getLocation() {
        return this.location;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockY() {
        return this.blockY;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public void setBlockX(int blockX) {
        this.blockX = blockX;
    }

    public void setBlockY(int blockY) {
        this.blockY = blockY;
    }

    public void setBlockZ(int blockZ) {
        this.blockZ = blockZ;
    }

    public int getSpawnRadius() {
        return this.spawnRadius;
    }

    public void setSpawnRadius(int spawnRadius) {
        this.spawnRadius = spawnRadius;
    }

    public int getSpawnRadiusY() {
        return this.spawnRadiusY;
    }

    public void setSpawnRadiusY(int spawnRadiusY) {
        this.spawnRadiusY = spawnRadiusY;
    }

    public PlaceholderInt getMaxMobs() {
        return this.maxMobs;
    }

    public void setMaxMobs(PlaceholderInt maxMobs) {
        this.maxMobs = maxMobs;
    }

    public int getMobsPerSpawn() {
        return this.mobsPerSpawn;
    }

    public void setMobsPerSpawn(int mobsPerSpawn) {
        this.mobsPerSpawn = mobsPerSpawn;
    }

    public RandomInt getMobLevel() {
        return this.mobLevel;
    }

    public void setMobLevel(RandomInt mobLevel) {
        this.mobLevel = mobLevel;
    }

    public boolean isShowFlames() {
        return this.showFlames;
    }

    public void setShowFlames(boolean showFlames) {
        this.showFlames = showFlames;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public void setBreakable(boolean breakable) {
        this.breakable = breakable;
    }

    public boolean isCheckForPlayers() {
        return this.checkForPlayers;
    }

    public void setCheckForPlayers(boolean checkForPlayers) {
        this.checkForPlayers = checkForPlayers;
    }

    public int getActivationRange() {
        return this.activationRange;
    }

    public void setActivationRange(int activationRange) {
        this.activationRange = activationRange;
    }

    public double getScalingRange() {
        return this.scalingRange;
    }

    public void setScalingRange(double scalingRange) {
        this.scalingRange = scalingRange;
    }

    public int getLeashRange() {
        return this.leashRange;
    }

    public void setLeashRange(int leashRange) {
        this.leashRange = leashRange;
    }

    public boolean isHealOnLeash() {
        return this.healOnLeash;
    }

    public void setHealOnLeash(boolean healOnLeash) {
        this.healOnLeash = healOnLeash;
    }

    public boolean isLeashResetsThreat() {
        return this.leashResetsThreat;
    }

    public void setLeashResetsThreat(boolean leashResetsThreat) {
        this.leashResetsThreat = leashResetsThreat;
    }
}

