/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.adventure.platform.facet;

import io.lumine.xikage.mythicmobs.utils.adventure.bossbar.BossBar;
import io.lumine.xikage.mythicmobs.utils.adventure.platform.facet.Facet;
import io.lumine.xikage.mythicmobs.utils.adventure.text.Component;
import io.lumine.xikage.mythicmobs.utils.adventure.translation.GlobalTranslator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

class FacetBossBarListener<V>
implements Facet.BossBar<V> {
    private final Facet.BossBar<V> facet;
    private final Supplier<Locale> locale;

    FacetBossBarListener(@NonNull Facet.BossBar<V> facet, @NonNull Supplier<Locale> locale) {
        this.facet = facet;
        this.locale = locale;
    }

    @Override
    public void bossBarInitialized(@NonNull BossBar bar) {
        this.facet.bossBarInitialized(bar);
        this.bossBarNameChanged(bar, bar.name(), bar.name());
    }

    @Override
    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.facet.bossBarNameChanged(bar, oldName, GlobalTranslator.render(newName, this.locale.get()));
    }

    @Override
    public void bossBarProgressChanged(@NonNull BossBar bar, float oldPercent, float newPercent) {
        this.facet.bossBarProgressChanged(bar, oldPercent, newPercent);
    }

    @Override
    public void bossBarColorChanged(@NonNull BossBar bar, @NonNull BossBar.Color oldColor, @NonNull BossBar.Color newColor) {
        this.facet.bossBarColorChanged(bar, oldColor, newColor);
    }

    @Override
    public void bossBarOverlayChanged(@NonNull BossBar bar, @NonNull BossBar.Overlay oldOverlay, @NonNull BossBar.Overlay newOverlay) {
        this.facet.bossBarOverlayChanged(bar, oldOverlay, newOverlay);
    }

    @Override
    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<BossBar.Flag> flagsAdded, @NonNull Set<BossBar.Flag> flagsRemoved) {
        this.facet.bossBarFlagsChanged(bar, flagsAdded, flagsRemoved);
    }

    @Override
    public void addViewer(@NonNull V viewer) {
        this.facet.addViewer(viewer);
    }

    @Override
    public void removeViewer(@NonNull V viewer) {
        this.facet.removeViewer(viewer);
    }

    @Override
    public boolean isEmpty() {
        return this.facet.isEmpty();
    }

    @Override
    public void close() {
        this.facet.close();
    }
}

