/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config;

import io.lumine.xikage.mythicmobs.utils.config.file.FileConfiguration;
import io.lumine.xikage.mythicmobs.utils.config.file.YamlConfiguration;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;

public class ConfigurationLoader<T extends LuminePlugin> {
    private FileConfiguration DataConfig = null;
    private File data = null;
    private T plugin;
    private String file;
    public File thefile;

    public ConfigurationLoader(T plugin, String newfile) {
        this(plugin, newfile, null);
    }

    public ConfigurationLoader(T plugin, String newfile, String folder) {
        this.plugin = plugin;
        this.file = newfile;
        if (folder != null) {
            folder = folder.replace("/", System.getProperty("file.separator"));
            this.thefile = new File(plugin.getDataFolder() + System.getProperty("file.separator") + folder, newfile);
        } else {
            this.thefile = new File(plugin.getDataFolder(), newfile);
        }
        if (this.thefile.exists()) {
            this.data = this.thefile;
        }
        this.reloadCustomConfig();
    }

    public ConfigurationLoader(T plugin, File newfile, String folder) {
        this.plugin = plugin;
        this.data = newfile;
        this.thefile = newfile;
        this.reloadCustomConfig();
    }

    public void reloadCustomConfig() {
        if (this.data == null) {
            this.data = new File(this.thefile.getParent(), this.file);
            this.DataConfig = YamlConfiguration.loadConfiguration(this.data);
            InputStream defConfigStream = this.plugin.getResource(this.file);
            if (defConfigStream != null) {
                YamlConfiguration defConfig = YamlConfiguration.loadConfiguration(this.data);
                this.DataConfig.setDefaults(defConfig);
            }
            this.getCustomConfig().options().copyDefaults(true);
            this.plugin.getLogger().log(Level.INFO, "File " + this.file + " not found! Creating a new one...");
            this.saveCustomConfig();
        } else {
            this.DataConfig = YamlConfiguration.loadConfiguration(this.data);
        }
    }

    public FileConfiguration getCustomConfig() {
        if (this.DataConfig == null) {
            this.reloadCustomConfig();
        }
        return this.DataConfig;
    }

    public void saveCustomConfig() {
        if (this.DataConfig == null || this.data == null) {
            return;
        }
        try {
            this.getCustomConfig().save(this.data);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.data, ex);
            ex.printStackTrace();
        }
    }

    public File getFile() {
        return this.thefile;
    }
}

