/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.config.properties.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.xikage.mythicmobs.utils.config.ConfigurationSection;
import io.lumine.xikage.mythicmobs.utils.config.properties.PropertyType;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.IconProp;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.LangProp;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.NodeListProp;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.StringListProp;
import io.lumine.xikage.mythicmobs.utils.config.properties.types.StringProp;
import io.lumine.xikage.mythicmobs.utils.menu.EditableIcon;
import io.lumine.xikage.mythicmobs.utils.menu.EditableMenuBuilder;
import io.lumine.xikage.mythicmobs.utils.menu.IconBuilder;
import io.lumine.xikage.mythicmobs.utils.menu.MenuBuilder;
import io.lumine.xikage.mythicmobs.utils.plugin.LuminePlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MenuProp<T>
extends PropertyType<EditableMenuBuilder<T>> {
    private MenuBuilder<T> def;
    private LangProp DISPLAY;
    private StringListProp SCHEMA;
    private NodeListProp ICON_NODES;

    public MenuProp(LuminePlugin plugin, Object file, String node, MenuBuilder<T> def) {
        super(plugin, file, node);
        this.DISPLAY = new LangProp(plugin, file, node + ".Display", "Menu");
        this.SCHEMA = new StringListProp(plugin, file, node + ".Schema");
        this.ICON_NODES = new NodeListProp(plugin, file, node + ".Icons");
        this.def = def;
    }

    @Override
    protected EditableMenuBuilder<T> compute(ConfigurationSection section, String node) {
        String strSlots;
        IconProp iconProp;
        if (section == null) {
            return this.getDefault();
        }
        String display = (String)this.DISPLAY.get(section);
        HashMap icons = new HashMap();
        List schema = (List)this.SCHEMA.get(section);
        HashMap schemaMap = Maps.newHashMap();
        ArrayList<Integer> schemaDataIcons = Lists.newArrayList();
        if (schema != null && !schema.isEmpty()) {
            int lineNumber = 0;
            for (String line : schema) {
                int i = 0;
                for (String string : line.split(" ")) {
                    if (string.equals("$")) {
                        schemaDataIcons.add(lineNumber * 9 + i);
                    } else {
                        if (!schemaMap.containsKey(string)) {
                            schemaMap.put(string, new ArrayList());
                        }
                        ((List)schemaMap.get(string)).add(lineNumber * 9 + i);
                    }
                    if (++i >= 9) break;
                }
                if (++lineNumber <= 6) continue;
                break;
            }
        }
        if (!schemaMap.isEmpty()) {
            for (String key : (Set)this.ICON_NODES.get(section)) {
                iconProp = new IconProp(this.plugin, this.file, node + ".Icons." + key);
                StringProp slotsProp = new StringProp(this.plugin, this.file, node + ".Icons." + key + ".Mapping");
                strSlots = (String)slotsProp.get(section);
                if (!schemaMap.containsKey(strSlots)) continue;
                List slots = (List)schemaMap.get(strSlots);
                IconBuilder iconBuilder = (IconBuilder)iconProp.get(section);
                iconBuilder.hideFlags();
                icons.put(key, new EditableIcon(iconBuilder, slots));
            }
        } else {
            for (String key : (Set)this.ICON_NODES.get(section)) {
                String[] split;
                iconProp = new IconProp(this.plugin, this.file, node + ".Icons." + key);
                StringProp slotsProp = new StringProp(this.plugin, this.file, node + ".Icons." + key + ".Slots");
                strSlots = (String)slotsProp.get(section);
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (String s2 : split = strSlots.split(",")) {
                    try {
                        int i = Integer.valueOf(s2);
                        slots.add(i);
                    }
                    catch (Error | Exception ex) {
                        ex.printStackTrace();
                    }
                }
                IconBuilder iconBuilder = (IconBuilder)iconProp.get(section);
                iconBuilder.hideFlags();
                icons.put(key, new EditableIcon(iconBuilder, slots));
            }
        }
        return new EditableMenuBuilder(MenuBuilder.create().title(display), icons, schemaDataIcons);
    }

    @Override
    public void set(String holder, EditableMenuBuilder<T> value) {
        if (this.config == null) {
            return;
        }
    }

    private EditableMenuBuilder getDefault() {
        return null;
    }
}

