/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.cooldown;

import io.lumine.xikage.mythicmobs.utils.cooldown.ComposedCooldownMapImpl;
import io.lumine.xikage.mythicmobs.utils.cooldown.Cooldown;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface ComposedCooldownMap<I, O> {
    @Nonnull
    public static <I, O> ComposedCooldownMap<I, O> create(@Nonnull Cooldown base, @Nonnull Function<I, O> composeFunction) {
        Objects.requireNonNull(base, "base");
        Objects.requireNonNull(composeFunction, "composeFunction");
        return new ComposedCooldownMapImpl<I, O>(base, composeFunction);
    }

    @Nonnull
    public Cooldown getBase();

    @Nonnull
    public Cooldown get(@Nonnull I var1);

    public void put(@Nonnull O var1, @Nonnull Cooldown var2);

    @Nonnull
    public Map<O, Cooldown> getAll();

    default public boolean test(@Nonnull I key) {
        return this.get(key).test();
    }

    default public boolean testSilently(@Nonnull I key) {
        return this.get(key).testSilently();
    }

    default public long elapsed(@Nonnull I key) {
        return this.get(key).elapsed();
    }

    default public void reset(@Nonnull I key) {
        this.get(key).reset();
    }

    default public long remainingMillis(@Nonnull I key) {
        return this.get(key).remainingMillis();
    }

    default public long remainingTime(@Nonnull I key, @Nonnull TimeUnit unit) {
        return this.get(key).remainingTime(unit);
    }

    @Nonnull
    default public OptionalLong getLastTested(@Nonnull I key) {
        return this.get(key).getLastTested();
    }

    default public void setLastTested(@Nonnull I key, long time) {
        this.get(key).setLastTested(time);
    }
}

