/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.menu;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.lumine.xikage.mythicmobs.utils.menu.Icon;
import io.lumine.xikage.mythicmobs.utils.menu.IconBuilder;
import io.lumine.xikage.mythicmobs.utils.menu.Menu;
import io.lumine.xikage.mythicmobs.utils.menu.MonitoredState;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MenuBuilder<T> {
    private final Map<Integer, Icon<? super T>> icons = Maps.newHashMap();
    private Function<T, String> titleFunc;
    private Function<T, MonitoredState> monitorFunc;
    private int curIconPos = -1;
    private List<Integer> dataSlots = Lists.newArrayList();
    private List<Integer> sortSlots = null;
    private List<Integer> blinkSlots = Lists.newArrayList();

    public static <T> MenuBuilder<T> create() {
        return new MenuBuilder<T>();
    }

    private MenuBuilder() {
    }

    public MenuBuilder<T> title(String title) {
        this.titleFunc = _state -> title;
        return this;
    }

    public MenuBuilder<T> title(Function<T, String> titleFunc) {
        this.titleFunc = titleFunc;
        return this;
    }

    public MenuBuilder<T> addIcon(Icon<? super T> icon) {
        do {
            ++this.curIconPos;
        } while (this.icons.containsKey(this.curIconPos));
        this.icons.put(this.curIconPos, icon);
        return this;
    }

    public MenuBuilder<T> addIcon(int slot, Icon<? super T> icon) {
        this.icons.put(slot, icon);
        if (icon.isBlinkingIcon()) {
            this.blinkSlots.add(slot);
        }
        return this;
    }

    public MenuBuilder<T> addAllIcons(List<Icon<T>> iconList) {
        for (Icon<T> icon : iconList) {
            do {
                ++this.curIconPos;
            } while (this.icons.containsKey(this.curIconPos));
            this.icons.put(this.curIconPos, icon);
            if (!icon.isBlinkingIcon()) continue;
            this.blinkSlots.add(this.curIconPos);
        }
        return this;
    }

    public MenuBuilder<T> addAllIcons(Map<Integer, Icon<T>> icons) {
        icons.entrySet().stream().forEach(integerIconEntry -> {
            this.icons.put((Integer)integerIconEntry.getKey(), (Icon<T>)integerIconEntry.getValue());
            if (((Icon)integerIconEntry.getValue()).isBlinkingIcon()) {
                this.blinkSlots.add((Integer)integerIconEntry.getKey());
            }
        });
        return this;
    }

    public MenuBuilder<T> createIcon(Function<IconBuilder<T>, IconBuilder<T>> builderFunc) {
        this.addIcon(builderFunc.apply(IconBuilder.create()).build());
        return this;
    }

    public MenuBuilder<T> createIcon(int slot, Function<IconBuilder<T>, IconBuilder<T>> builderFunc) {
        this.addIcon(slot, builderFunc.apply(IconBuilder.create()).build());
        return this;
    }

    public MenuBuilder<T> monitor(Function<T, MonitoredState> func) {
        this.monitorFunc = func;
        return this;
    }

    public MenuBuilder<T> staticMenu() {
        this.monitorFunc = _obj -> () -> 0L;
        return this;
    }

    public Menu<T> build() {
        if (this.titleFunc == null) {
            throw new IllegalStateException("Title must be specified!");
        }
        if (this.sortSlots == null) {
            return new Menu<T>(this.titleFunc, this.monitorFunc, this.icons, this.dataSlots, this.blinkSlots);
        }
        return new Menu<T>(this.titleFunc, this.monitorFunc, this.icons, this.dataSlots, this.sortSlots, this.blinkSlots);
    }

    public MenuBuilder<T> dataSlots(List<Integer> dataSlots) {
        this.dataSlots = dataSlots;
        return this;
    }

    public MenuBuilder<T> sortByAmount(List<Integer> sortable) {
        this.sortSlots = sortable;
        return this;
    }
}

